package ru.yandex.direct.web.entity.useractionlog;

import javax.annotation.ParametersAreNonnullByDefault;

import org.dataloader.DataLoaderRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Набор всех DataLoader'ов, которые используются пользовательскими логами.
 */
@Component
@ParametersAreNonnullByDefault
public class UserActionLogDataLoaderRegistry extends DataLoaderRegistry {
    private final UserViewByUidDataLoader userViewByUidDataLoader;
    private final GoalViewByIdDataLoader goalViewByIdDataLoader;
    private final TimeZoneViewByIdDataLoader timeZoneViewByIdDataLoader;
    private final DictRepositoryDataLoader dictRepositoryDataLoader;
    private final ClientNameByClientIdDataLoader clientNameByClientIdDataLoader;

    @Autowired
    public UserActionLogDataLoaderRegistry(UserViewByUidDataLoader userViewByUidDataLoader,
                                           GoalViewByIdDataLoader goalViewByIdDataLoader,
                                           TimeZoneViewByIdDataLoader timeZoneViewByIdDataLoader,
                                           DictRepositoryDataLoader dictRepositoryDataLoader,
                                           ClientNameByClientIdDataLoader clientNameByClientIdDataLoader) {
        super();

        this.userViewByUidDataLoader = userViewByUidDataLoader;
        register("userViewByUidDataLoader", this.userViewByUidDataLoader);

        this.goalViewByIdDataLoader = goalViewByIdDataLoader;
        register("goalViewByIdDataLoader", goalViewByIdDataLoader);

        this.timeZoneViewByIdDataLoader = timeZoneViewByIdDataLoader;
        register("timeZoneViewByIdDataLoader", timeZoneViewByIdDataLoader);

        this.dictRepositoryDataLoader = dictRepositoryDataLoader;
        register("dictRepositoryDataLoader", dictRepositoryDataLoader);

        this.clientNameByClientIdDataLoader = clientNameByClientIdDataLoader;
        register("clientNameByClientIdDataLoader", clientNameByClientIdDataLoader);
    }

    public GoalViewByIdDataLoader getGoalViewByIdDataLoader() {
        return goalViewByIdDataLoader;
    }

    public UserViewByUidDataLoader getUserViewByUidDataLoader() {
        return userViewByUidDataLoader;
    }

    public TimeZoneViewByIdDataLoader getTimeZoneViewByIdDataLoader() {
        return timeZoneViewByIdDataLoader;
    }

    public DictRepositoryDataLoader getDictRepositoryDataLoader() {
        return dictRepositoryDataLoader;
    }

    public ClientNameByClientIdDataLoader getClientNameByClientIdDataLoader() {
        return clientNameByClientIdDataLoader;
    }
}
