package ru.yandex.direct.web.entity.useractionlog;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.types.GraphQLType;

@GraphQLType(name = "User")
@ParametersAreNonnullByDefault
public class UserView {
    static final UserView EMPTY = new UserView(0, "");

    /**
     * DIRECT-76205
     * Специальный псевдо-пользователь, появление которого говорит может быть связано с одним из двух случае:
     * <ul>
     * <li>Изменение было сделано яндексовым роботом, скриптом, задачей и т.п.</li>
     * <li>Изменение было сделано человеком, информацию о котором не следует разглашать запрашивающей стороне.</li>
     * </ul>
     */
    static final UserView YANDEX_STAFF = new UserView(-1, "yandex");

    /**
     * DIRECT-80105
     * Чтобы не рассказать клиенту, который представился агентством, информацию о контракте агентства с Яндексом
     */
    static final UserView AGENCY = new UserView(-2, "agency");

    private final long uid;
    private final String login;

    public UserView(long uid, String login) {
        this.uid = uid;
        this.login = login;
    }

    @GraphQLQuery(name = "uid")
    public long getUid() {
        return uid;
    }

    @Nonnull
    @GraphQLQuery(name = "login")
    public @GraphQLNonNull
    String getLogin() {
        return login;
    }
}
