package ru.yandex.direct.web.entity.useractionlog.controller;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

import ru.yandex.direct.libs.graphql.model.GraphqlRequest;
import ru.yandex.direct.libs.graphql.model.GraphqlResponse;
import ru.yandex.direct.web.annotations.AllowedOperatorRoles;
import ru.yandex.direct.web.annotations.AllowedSubjectRoles;
import ru.yandex.direct.web.core.security.csrf.CsrfCheck;
import ru.yandex.direct.web.entity.useractionlog.UserActionLogGraphQLService;

import static ru.yandex.direct.rbac.RbacRole.AGENCY;
import static ru.yandex.direct.rbac.RbacRole.CLIENT;
import static ru.yandex.direct.rbac.RbacRole.INTERNAL_AD_ADMIN;
import static ru.yandex.direct.rbac.RbacRole.INTERNAL_AD_MANAGER;
import static ru.yandex.direct.rbac.RbacRole.INTERNAL_AD_SUPERREADER;
import static ru.yandex.direct.rbac.RbacRole.LIMITED_SUPPORT;
import static ru.yandex.direct.rbac.RbacRole.MANAGER;
import static ru.yandex.direct.rbac.RbacRole.MEDIA;
import static ru.yandex.direct.rbac.RbacRole.PLACER;
import static ru.yandex.direct.rbac.RbacRole.SUPER;
import static ru.yandex.direct.rbac.RbacRole.SUPERREADER;
import static ru.yandex.direct.rbac.RbacRole.SUPPORT;

@ApiIgnore  // не хотим показывать в swagger-е
@Controller
@ParametersAreNonnullByDefault
@RequestMapping("/user-action-log")
public class UserActionLogController {
    private final UserActionLogGraphQLService userActionLogGraphQLService;

    @Autowired
    public UserActionLogController(UserActionLogGraphQLService userActionLogGraphQLService) {
        this.userActionLogGraphQLService = userActionLogGraphQLService;
    }

    /**
     * Статический интерфейс graphiql для отладки контроллера
     */
    @GetMapping(value = "/")
    @AllowedOperatorRoles({SUPER, SUPERREADER})
    @AllowedSubjectRoles({SUPER, SUPERREADER})
    public String graphiqlInterface() {
        return "/static/graphiql.html";
    }

    @AllowedSubjectRoles({SUPER, SUPERREADER, SUPPORT, PLACER, MEDIA, MANAGER, AGENCY,
            INTERNAL_AD_ADMIN, INTERNAL_AD_MANAGER, INTERNAL_AD_SUPERREADER,
            LIMITED_SUPPORT, CLIENT})
    @CsrfCheck(enabled = false)
    @RequestMapping(
            value = "/api",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE
    )
    @ResponseBody
    public GraphqlResponse executeGraphQL(@RequestBody GraphqlRequest request) {
        return userActionLogGraphQLService.executeGraphQL(request);
    }
}
