package ru.yandex.direct.web.entity.useractionlog.model;


import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.useractionlog.reader.model.LogRecord;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
public class UserActionLogResult {
    @JsonProperty("Timezone")
    private final String timezone = "UTC";

    @JsonProperty("Records")
    private List<LogRecord> records = null;

    @JsonProperty("LimitedBy")
    private String limitedBy = null;

    public UserActionLogResult withRecords(List<LogRecord> records) {
        this.records = records;
        return this;
    }

    public UserActionLogResult withLimitedBy(String limitedBy) {
        this.limitedBy = limitedBy;
        return this;
    }
}
