package ru.yandex.direct.web.entity.useractionlog.model;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;

public class UserActionLogSelectionCriteria {
    @ApiModelProperty(value = "Показать события начиная с этой даты и времени включительно")
    @JsonProperty("DateFrom")
    public LocalDateTime dateFrom;

    @ApiModelProperty(value = "Показать события заканчивая этой датой и временем включительно")
    @JsonProperty("DateTo")
    public LocalDateTime dateTo;

    @ApiModelProperty(value = "Набор фильтров")
    @JsonProperty("Filters")
    public List<Filter> filters;

    public static class Filter {
        @ApiModelProperty(value = "Название поля для фильтрации")
        @JsonProperty(value = "Field", required = true)
        public Field field;

        @ApiModelProperty(value = "Операция фильтрации")
        @JsonProperty(value = "Operator", required = true)
        public Operator operator;

        @ApiModelProperty(value = "Значение поля. Для EQUALS ожидается список значений, для остальных операций - значение.")
        @JsonProperty(value = "Value", required = true)
        public Object value;

        public enum Field {
            CLIENT_PATH("ClientPath"),
            CAMPAIGN_PATH("CampaignPath"),
            ADGROUP_PATH("AdGroupPath"),
            AD_PATH("AdPath");

            private final String name;
            private static HashMap<String, Field> byName = new HashMap<>();

            static {
                for (Field field : Field.class.getEnumConstants()) {
                    byName.put(field.getName(), field);
                }
            }

            Field(String name) {
                this.name = name;
            }

            @JsonValue
            public String getName() {
                return name;
            }

            @JsonCreator
            public static Field getByName(String name) {
                return Objects.requireNonNull(byName.get(name));
            }
        }

        public enum Operator {
            EQUALS,
            IN;
        }
    }
}
