package ru.yandex.direct.web.entity.vcard.controller;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.model.WebSuccessResponse;
import ru.yandex.direct.web.core.security.captcha.DisableAutoCaptcha;
import ru.yandex.direct.web.entity.vcard.model.AssignVcardWebRequest;
import ru.yandex.direct.web.entity.vcard.model.SaveVcardWebRequest;
import ru.yandex.direct.web.entity.vcard.model.UnassignVcardWebRequest;
import ru.yandex.direct.web.entity.vcard.service.WebVcardsService;

import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN;


@Controller
@RequestMapping(value = "/vcard",
        produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "vcard")
public class VcardController {
    private final WebVcardsService webVcardsService;

    @Autowired
    public VcardController(WebVcardsService webVcardsService) {
        this.webVcardsService = webVcardsService;
    }

    @ApiOperation(
            value = "saveVcard",
            httpMethod = "POST",
            nickname = "saveVcard"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "/save", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse saveVcard(
            @RequestBody SaveVcardWebRequest webRequest,
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return webVcardsService.saveVcard(webRequest);
    }

    @ApiOperation(
            value = "assignVcard",
            httpMethod = "POST",
            nickname = "assignVcard"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "/assign", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse assignVcard(
            @RequestBody AssignVcardWebRequest webRequest,
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return webVcardsService.assignVcard(webRequest);
    }

    @ApiOperation(
            value = "unassignVcard",
            httpMethod = "POST",
            nickname = "unassignVcard"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "/unassign", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse unassignVcard(
            @RequestBody UnassignVcardWebRequest webRequest,
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return webVcardsService.unassignVcard(webRequest);
    }
}
