package ru.yandex.direct.web.entity.vcard.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class SaveVcardWebRequest {
    public static final String CID = "cid";
    public static final String BIDS = "bids";
    public static final String VCARD_ID = "vcard_id";
    public static final String VCARD = "vcard";

    @JsonProperty(CID)
    private Long cid;

    @JsonProperty(BIDS)
    private List<Long> bids;

    @JsonProperty(VCARD_ID)
    private Long vcardId;

    @JsonProperty(VCARD)
    private WebVcard vcard;

    public Long getCid() {
        return cid;
    }

    public SaveVcardWebRequest withCid(Long cid) {
        this.cid = cid;
        return this;
    }

    public List<Long> getBids() {
        return bids;
    }

    public SaveVcardWebRequest withBids(List<Long> bids) {
        this.bids = bids;
        return this;
    }

    public Long getVcardId() {
        return vcardId;
    }

    public SaveVcardWebRequest withVcardId(Long vcardId) {
        this.vcardId = vcardId;
        return this;
    }

    public WebVcard getVcard() {
        return vcard;
    }

    public SaveVcardWebRequest withVcard(WebVcard vcard) {
        this.vcard = vcard;
        return this;
    }
}
