package ru.yandex.direct.web.entity.vcard.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebPhone {
    public static final String COUNTRY_CODE_FIELD_NAME = "country_code";
    public static final String CITY_CODE_FIELD_NAME = "city_code";
    public static final String PHONE_NUMBER_FIELD_NAME = "phone_number";
    public static final String EXTENSION_FIELD_NAME = "extension";

    @JsonProperty(COUNTRY_CODE_FIELD_NAME)
    private String countryCode;

    @JsonProperty(CITY_CODE_FIELD_NAME)
    private String cityCode;

    @JsonProperty(PHONE_NUMBER_FIELD_NAME)
    private String phoneNumber;

    @JsonProperty(EXTENSION_FIELD_NAME)
    private String extension;

    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public WebPhone withCountryCode(String countryCode) {
        setCountryCode(countryCode);
        return this;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public WebPhone withCityCode(String cityCode) {
        setCityCode(cityCode);
        return this;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public WebPhone withPhoneNumber(String phoneNumber) {
        setPhoneNumber(phoneNumber);
        return this;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public WebPhone withExtension(String extension) {
        setExtension(extension);
        return this;
    }
}
