package ru.yandex.direct.web.entity.vcard.presentations;

import ru.yandex.direct.core.entity.vcard.container.AssignVcardRequest;
import ru.yandex.direct.core.entity.vcard.container.SaveVcardRequest;
import ru.yandex.direct.core.entity.vcard.container.UnassignVcardRequest;
import ru.yandex.direct.validation.result.MappingPathNodeConverter;
import ru.yandex.direct.web.entity.vcard.model.AssignVcardWebRequest;
import ru.yandex.direct.web.entity.vcard.model.SaveVcardWebRequest;
import ru.yandex.direct.web.entity.vcard.model.UnassignVcardWebRequest;

public class ManageVcardsPathConverters {

    public static final MappingPathNodeConverter SAVE_VCARD_PATH_CONVERTER =
            MappingPathNodeConverter.builder(ManageVcardsPathConverters.class.getName())
                    .replace(SaveVcardRequest.CAMPAIGN_ID.name(), SaveVcardWebRequest.CID)
                    .replace(SaveVcardRequest.BANNER_IDS.name(), SaveVcardWebRequest.BIDS)
                    .replace(SaveVcardRequest.VCARD_ID.name(), SaveVcardWebRequest.VCARD_ID)
                    .replace(SaveVcardRequest.VCARD.name(), SaveVcardWebRequest.VCARD)
                    .build();

    public static final MappingPathNodeConverter ASSIGN_VCARD_PATH_CONVERTER =
            MappingPathNodeConverter.builder(ManageVcardsPathConverters.class.getName())
                    .replace(AssignVcardRequest.CAMPAIGN_ID.name(), AssignVcardWebRequest.CID)
                    .replace(AssignVcardRequest.BANNER_IDS.name(), AssignVcardWebRequest.BIDS)
                    .replace(AssignVcardRequest.VCARD_ID.name(), AssignVcardWebRequest.VCARD_ID)
                    .build();

    public static final MappingPathNodeConverter UNASSIGN_VCARD_PATH_CONVERTER =
            MappingPathNodeConverter.builder(ManageVcardsPathConverters.class.getName())
                    .replace(UnassignVcardRequest.CAMPAIGN_ID.name(), UnassignVcardWebRequest.CID)
                    .replace(UnassignVcardRequest.BANNER_IDS.name(), UnassignVcardWebRequest.BIDS)
                    .build();
}
