package ru.yandex.direct.web.entity.vcard.presentations;

import ru.yandex.direct.core.entity.vcard.VcardDefectTranslations;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.core.entity.vcard.service.validation.AddVcardValidationService.StringLengthDefectIds.CONTACT_EMAIL_TOO_LONG;
import static ru.yandex.direct.core.entity.vcard.service.validation.AddVcardValidationService.VoidDefectIds.CONTACT_EMAIL_INVALID_FORMAT;
import static ru.yandex.direct.core.entity.vcard.service.validation.AddVcardValidationService.VoidDefectIds.CONTACT_EMAIL_IS_EMPTY;
import static ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator.StringDefectIds.LOGIN_IS_TOO_LONG;
import static ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator.VoidDefectIds.INVALID_ICQ_LOGIN_FORMAT;
import static ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator.VoidDefectIds.INVALID_JABBER_LOGIN_FORMAT;
import static ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator.VoidDefectIds.INVALID_MAIL_AGENT_LOGIN_FORMAT;
import static ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator.VoidDefectIds.INVALID_SKYPE_OR_MSN_LOGIN_FORMAT;
import static ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator.VoidDefectIds.LOGIN_IS_NULL;
import static ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator.VoidDefectIds.TYPE_IS_NULL;
import static ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator.VoidDefectIds.UNSUPPORTED_TYPE;
import static ru.yandex.direct.core.entity.vcard.service.validation.MetroIdValidator.DefectIds.INVALID_METRO;
import static ru.yandex.direct.core.entity.vcard.service.validation.MetroIdValidator.DefectIds.METRO_CITY_IS_REQUIRED;
import static ru.yandex.direct.core.entity.vcard.service.validation.OgrnConstraint.VoidDefectIds.INVALID_OGRN;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.CityCodeDefectIds.COUNTRY_CODE_MUST_NOT_START_WITH_PLUS;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.CITY_CODE_IS_EMPTY;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.CITY_CODE_IS_TOO_LONG;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.COUNTRY_CODE_IS_EMPTY;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.COUNTRY_CODE_IS_TOO_LONG;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.ENTIRE_PHONE_LENGTH_IS_INVALID;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.ENTIRE_PHONE_WITH_EXTENSION_IS_TOO_LONG;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.EXTENSION_IS_TOO_LONG;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.PHONE_NUMBER_IS_EMPTY;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.PHONE_NUMBER_IS_TOO_LONG;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.StringLengthDefectIds.PHONE_NUMBER_IS_TOO_SHORT;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.VoidDefectIds.CITY_CODE_FORMAT_IS_INVALID;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.VoidDefectIds.CITY_CODE_IS_NULL;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.VoidDefectIds.COUNTRY_CODE_FORMAT_IS_INVALID;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.VoidDefectIds.COUNTRY_CODE_IS_NULL;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.VoidDefectIds.COUNTRY_CODE_MUST_START_WITH_PLUS;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.VoidDefectIds.EXTENSION_FORMAT_IS_INVALID;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.VoidDefectIds.PHONE_NUMBER_FORMAT_IS_INVALID;
import static ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator.VoidDefectIds.PHONE_NUMBER_IS_NULL;
import static ru.yandex.direct.core.entity.vcard.service.validation.VcardDefectIds.Gen.BANNERS_WITH_VCARD_ID_NOT_FOUND;
import static ru.yandex.direct.core.entity.vcard.service.validation.VcardDefectIds.Gen.INCONSISTENT_VCARD_CID_AND_CAMPAIGN_ID;
import static ru.yandex.direct.core.entity.vcard.service.validation.VcardDefectIds.Gen.VCARD_HAS_VALIDATION_ERRORS;
import static ru.yandex.direct.core.entity.vcard.service.validation.VcardDefectIds.Gen.VCARD_IS_DUPLICATED;
import static ru.yandex.direct.core.entity.vcard.service.validation.VcardDefectIds.Gen.VCARD_IS_IN_USE;
import static ru.yandex.direct.core.entity.vcard.service.validation.WorkTimeConstraint.StringDefectIds.WORKTIME_IS_TOO_LONG;
import static ru.yandex.direct.core.entity.vcard.service.validation.WorkTimeConstraint.VoidDefectIds.WORKTIME_DAYS_DUPLICATED;
import static ru.yandex.direct.core.entity.vcard.service.validation.WorkTimeConstraint.VoidDefectIds.WORKTIME_FORMAT_IS_INVALID;
import static ru.yandex.direct.core.entity.vcard.service.validation.WorkTimeConstraint.VoidDefectIds.WORKTIME_IS_EMPTY;
import static ru.yandex.direct.core.entity.vcard.service.validation.WorkTimeConstraint.VoidDefectIds.WORKTIME_MINUTE_NOT_DIVISIBLE_BY_15;
import static ru.yandex.direct.core.entity.vcard.service.validation.WorkTimeConstraint.VoidDefectIds.WORKTIME_TIME_FORMAT_IS_INVALID;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.webDefect;

public class VcardDefectPresentations {

    private VcardDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> vcardDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(VCARD_IS_IN_USE, defaultWebDefect())

                .register(TYPE_IS_NULL, defaultWebDefect())
                .register(UNSUPPORTED_TYPE, defaultWebDefect())

                .register(LOGIN_IS_NULL, defaultWebDefect())
                .register(LOGIN_IS_TOO_LONG, defaultWebDefect())

                .register(INVALID_ICQ_LOGIN_FORMAT, defaultWebDefect())
                .register(INVALID_MAIL_AGENT_LOGIN_FORMAT, defaultWebDefect())
                .register(INVALID_JABBER_LOGIN_FORMAT, defaultWebDefect())
                .register(INVALID_SKYPE_OR_MSN_LOGIN_FORMAT, defaultWebDefect())

                .register(INVALID_OGRN, defaultWebDefect())

                .register(COUNTRY_CODE_IS_NULL, defaultWebDefect())
                .register(COUNTRY_CODE_MUST_START_WITH_PLUS, defaultWebDefect())
                .register(COUNTRY_CODE_MUST_NOT_START_WITH_PLUS, defaultWebDefect())
                .register(COUNTRY_CODE_FORMAT_IS_INVALID, defaultWebDefect())
                .register(COUNTRY_CODE_IS_EMPTY, defaultWebDefect())
                .register(COUNTRY_CODE_IS_TOO_LONG, defaultWebDefect())

                .register(CITY_CODE_IS_NULL, defaultWebDefect())
                .register(CITY_CODE_FORMAT_IS_INVALID, defaultWebDefect())
                .register(CITY_CODE_IS_EMPTY, defaultWebDefect())
                .register(CITY_CODE_IS_TOO_LONG, defaultWebDefect())

                .register(PHONE_NUMBER_IS_NULL, defaultWebDefect())
                .register(PHONE_NUMBER_IS_EMPTY, defaultWebDefect())
                .register(PHONE_NUMBER_IS_TOO_SHORT, defaultWebDefect())
                .register(PHONE_NUMBER_IS_TOO_LONG, defaultWebDefect())
                .register(PHONE_NUMBER_FORMAT_IS_INVALID, defaultWebDefect())

                .register(EXTENSION_FORMAT_IS_INVALID, defaultWebDefect())
                .register(EXTENSION_IS_TOO_LONG, defaultWebDefect())
                .register(ENTIRE_PHONE_LENGTH_IS_INVALID, defaultWebDefect())
                .register(ENTIRE_PHONE_WITH_EXTENSION_IS_TOO_LONG, defaultWebDefect())

                .register(CONTACT_EMAIL_IS_EMPTY, defaultWebDefect())
                .register(CONTACT_EMAIL_TOO_LONG, defaultWebDefect())
                .register(CONTACT_EMAIL_INVALID_FORMAT, defaultWebDefect())

                .register(METRO_CITY_IS_REQUIRED, defaultWebDefect())
                .register(INVALID_METRO, defaultWebDefect())

                .register(WORKTIME_IS_EMPTY, defaultWebDefect())
                .register(WORKTIME_IS_TOO_LONG, defaultWebDefect())
                .register(WORKTIME_FORMAT_IS_INVALID, defaultWebDefect())
                .register(WORKTIME_TIME_FORMAT_IS_INVALID, defaultWebDefect())
                .register(WORKTIME_MINUTE_NOT_DIVISIBLE_BY_15, defaultWebDefect())
                .register(WORKTIME_DAYS_DUPLICATED, defaultWebDefect())

                .register(VCARD_IS_DUPLICATED,
                        webDefect(VcardDefectTranslations.INSTANCE.vcardIsDuplicated()))
                .register(BANNERS_WITH_VCARD_ID_NOT_FOUND, defaultWebDefect())
                .register(VCARD_HAS_VALIDATION_ERRORS, defaultWebDefect())
                .register(INCONSISTENT_VCARD_CID_AND_CAMPAIGN_ID, defaultWebDefect())
                .build();
    }
}
