package ru.yandex.direct.web.entity.vcard.presentations;

import ru.yandex.direct.core.entity.vcard.model.InstantMessenger;
import ru.yandex.direct.core.entity.vcard.model.Phone;
import ru.yandex.direct.core.entity.vcard.model.PointOnMap;
import ru.yandex.direct.core.entity.vcard.model.Vcard;
import ru.yandex.direct.validation.result.MappingPathNodeConverter;
import ru.yandex.direct.web.entity.vcard.model.WebInstantMessenger;
import ru.yandex.direct.web.entity.vcard.model.WebPhone;
import ru.yandex.direct.web.entity.vcard.model.WebPointOnMap;
import ru.yandex.direct.web.entity.vcard.model.WebVcard;

public class VcardPathConverter {

    public static final MappingPathNodeConverter VCARD_PATH_CONVERTER =
            MappingPathNodeConverter.builder(VcardPathConverter.class.getName())
                    .replace(Vcard.CAMPAIGN_ID.name(), WebVcard.CAMPAIGN_ID_FIELD_NAME)
                    .replace(Vcard.COMPANY_NAME.name(), WebVcard.COMPANY_NAME_FIELD_NAME)
                    .replace(Vcard.WORK_TIME.name(), WebVcard.WORK_TIME_FIELD_NAME)
                    .replace(Vcard.CONTACT_PERSON.name(), WebVcard.CONTACT_PERSON_FIELD_NAME)
                    .replace(Vcard.PHONE.name(), WebVcard.PHONE_FIELD_NAME)
                    .replace(Vcard.EMAIL.name(), WebVcard.EMAIL_FIELD_NAME)
                    .replace(Vcard.INSTANT_MESSENGER.name(), WebVcard.INSTANT_MESSENGER_FIELD_NAME)
                    .replace(Vcard.EXTRA_MESSAGE.name(), WebVcard.EXTRA_MESSAGE_FIELD_NAME)
                    .replace(Vcard.OGRN.name(), WebVcard.OGRN_FIELD_NAME)
                    .replace(Vcard.COUNTRY.name(), WebVcard.COUNTRY_FIELD_NAME)
                    .replace(Vcard.CITY.name(), WebVcard.CITY_FIELD_NAME)
                    .replace(Vcard.STREET.name(), WebVcard.STREET_FIELD_NAME)
                    .replace(Vcard.HOUSE.name(), WebVcard.HOUSE_FIELD_NAME)
                    .replace(Vcard.BUILD.name(), WebVcard.BUILD_FIELD_NAME)
                    .replace(Vcard.APART.name(), WebVcard.APART_FIELD_NAME)
                    .replace(Vcard.METRO_ID.name(), WebVcard.METRO_ID_FIELD_NAME)
                    .replace(Vcard.MANUAL_POINT.name(), WebVcard.MANUAL_POINT_FIELD_NAME)
                    .build();

    public static final MappingPathNodeConverter PHONE_PATH_CONVERTER =
            MappingPathNodeConverter.builder(VcardPathConverter.class.getName())
                    .replace(Phone.COUNTRY_CODE.name(), WebPhone.COUNTRY_CODE_FIELD_NAME)
                    .replace(Phone.CITY_CODE.name(), WebPhone.CITY_CODE_FIELD_NAME)
                    .replace(Phone.PHONE_NUMBER.name(), WebPhone.PHONE_NUMBER_FIELD_NAME)
                    .replace(Phone.EXTENSION.name(), WebPhone.EXTENSION_FIELD_NAME)
                    .build();

    public static final MappingPathNodeConverter INSTANT_MESSENGER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(VcardPathConverter.class.getName())
                    .replace(InstantMessenger.TYPE.name(), WebInstantMessenger.TYPE_FIELD_NAME)
                    .replace(InstantMessenger.LOGIN.name(), WebInstantMessenger.LOGIN_FIELD_NAME)
                    .build();

    public static final MappingPathNodeConverter POINT_ON_MAP_PATH_CONVERTER =
            MappingPathNodeConverter.builder(VcardPathConverter.class.getName())
                    .replace(PointOnMap.X.name(), WebPointOnMap.X_FIELD_NAME)
                    .replace(PointOnMap.Y.name(), WebPointOnMap.Y_FIELD_NAME)
                    .replace(PointOnMap.X1.name(), WebPointOnMap.X1_FIELD_NAME)
                    .replace(PointOnMap.Y1.name(), WebPointOnMap.Y1_FIELD_NAME)
                    .replace(PointOnMap.X2.name(), WebPointOnMap.X2_FIELD_NAME)
                    .replace(PointOnMap.Y2.name(), WebPointOnMap.Y2_FIELD_NAME)
                    .build();
}
