package ru.yandex.direct.web.logging;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.logging.LogRecordHolder;
import ru.yandex.direct.core.security.DirectAuthentication;
import ru.yandex.direct.utils.CommonUtils;

@Component
public class WebAuthenticationInfoLoggingFilter implements Filter {

    private LogRecordHolder<WebLogRecord> webLogRecordHolder;

    @Autowired
    public WebAuthenticationInfoLoggingFilter(LogRecordHolder<WebLogRecord> webLogRecordHolder) {
        this.webLogRecordHolder = webLogRecordHolder;
    }

    @Override
    public void init(FilterConfig filterConfig) {
        // no initialization
    }

    @Override
    public void destroy() {
        // no finalization
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
            throws IOException, ServletException {
        WebLogRecord webLogRecord = webLogRecordHolder.getLogRecord();
        fillAuthenticationInfo(webLogRecord);
        chain.doFilter(request, response);
    }

    private void fillAuthenticationInfo(WebLogRecord webLogRecord) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof DirectAuthentication) {
            DirectAuthentication directAuthentication = (DirectAuthentication) authentication;
            webLogRecord.setOperatorId(directAuthentication.getOperator().getUid());
            webLogRecord.setCluid(CommonUtils.nvl(directAuthentication.getSubjectUser().getChiefUid(),
                    directAuthentication.getSubjectUser().getUid()));
            webLogRecord.setOperatorRole(directAuthentication.getOperator().getRole());
        }
    }
}
