package ru.yandex.direct.web.logging;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.gson.JsonParseException;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.WebUtils;

import ru.yandex.direct.common.logging.LogRecord;
import ru.yandex.direct.rbac.RbacRole;
import ru.yandex.direct.utils.JsonUtils;

@SuppressWarnings({"FieldCanBeLocal", "unused", "WeakerAccess"})
public class WebLogRecord extends LogRecord {

    private static final String LOG_SERVICE_NAME = "direct.java.webapi";
    private static final String PARAM_OPERATION_NAME = "operationName";

    @JsonProperty("role")
    private RbacRole operatorRole;

    @JsonProperty("cluid")
    private Long clientUid;

    @JsonProperty("yandexuid")
    private String yandexUid;

    public WebLogRecord(long requestId, HttpServletRequest request) {
        super(requestId, request);
    }

    public void setOperatorRole(RbacRole operatorRole) {
        this.operatorRole = operatorRole;
    }

    public void setCluid(Long cluid) {
        this.clientUid = cluid;
    }

    public void setYandexUid(String yandexUid) {
        this.yandexUid = yandexUid;
    }

    public void addGridNameToPath(HttpServletRequest request) {
        String path = getPath();
        if (path == null) {
            return;
        }

        var contentRequest = WebUtils.getNativeRequest(request, ContentCachingRequestWrapper.class);

        if (path.contains("grid") && contentRequest != null) {
            JsonNode jsonNode;
            try {
                jsonNode = JsonUtils.MAPPER.readTree(contentRequest.getContentAsByteArray());
            } catch (JsonParseException | IOException e) {
                return;
            }
            if (jsonNode != null && jsonNode.hasNonNull(PARAM_OPERATION_NAME)) {
                String opName = jsonNode
                        .get(PARAM_OPERATION_NAME)
                        .asText("");
                if (!opName.isBlank()) {
                    setPath(path + "." + opName);
                }
            }
        }
    }

    @Override
    public String getService() {
        return LOG_SERVICE_NAME;
    }
}
