package ru.yandex.direct.web.logging;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.logging.LogRecordHolder;
import ru.yandex.direct.common.logging.LoggingFilter;
import ru.yandex.direct.common.logging.LoggingSettings;
import ru.yandex.direct.common.util.HttpUtil;
import ru.yandex.direct.tracing.Trace;

@Component
@ParametersAreNonnullByDefault
public class WebLoggingFilter extends LoggingFilter<WebLogRecord> {

    private static final String LOGGER_NAME = "PPCLOG_CMD.log";

    @Autowired
    public WebLoggingFilter(LoggingSettings loggingDefaults, LogRecordHolder<WebLogRecord> logRecordHolder) {
        super(LOGGER_NAME, loggingDefaults, logRecordHolder);
    }

    @Override
    protected void initLogRecord(long requestId, HttpServletRequest requestToUse) {
        WebLogRecord webLogRecord = createWebLogRecord(requestToUse);
        logRecordHolder.setLogRecord(webLogRecord);
    }


    private WebLogRecord createWebLogRecord(HttpServletRequest httpRequest) {
        WebLogRecord webLogRecord = new WebLogRecord(Trace.current().getSpanId(), httpRequest);
        String yandexUid = HttpUtil.getCookieValue("yandexuid", httpRequest).orElse(null);
        webLogRecord.setYandexUid(yandexUid);
        return webLogRecord;
    }

    @Override
    protected void beforeLogCall(HttpServletRequest request) {
        logRecordHolder.getLogRecord().addGridNameToPath(request);
    }
}
