package ru.yandex.direct.web.validation;

import ru.yandex.direct.core.entity.adgeneration.model.GenerationDefectIds;
import ru.yandex.direct.core.entity.calltrackingsettings.validation.CalltrackingSettingDefects;
import ru.yandex.direct.core.entity.client.service.validation.ClientDefects;
import ru.yandex.direct.core.entity.clientphone.validation.ClientPhoneDefects;
import ru.yandex.direct.core.entity.contentpromotion.validation.defects.ContentPromotionDefectIds;
import ru.yandex.direct.core.entity.conversionsource.validation.ConversionSourceDefects;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.validation.DynamicTextAdTargetDefectIds;
import ru.yandex.direct.core.entity.feedoffer.validation.FeedOfferDefects;
import ru.yandex.direct.core.entity.freelancer.service.validation.AvatarsDefects;
import ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefectTranslations;
import ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects;
import ru.yandex.direct.core.entity.hrefparams.validation.defects.HrefParamsDefectIds;
import ru.yandex.direct.core.entity.hypergeo.validation.HyperGeoDefectIds;
import ru.yandex.direct.core.entity.image.service.validation.ImageDefectIds;
import ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdsAccessGroupDefects;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseDefectIds;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseDefectTranslations;
import ru.yandex.direct.core.entity.mobileapp.MobileAppDefects;
import ru.yandex.direct.core.entity.organizations.validation.OrganizationDefectIds;
import ru.yandex.direct.core.entity.organizations.validation.OrganizationDefectTranslations;
import ru.yandex.direct.core.entity.performancefilter.service.PerformanceFilterDefects;
import ru.yandex.direct.core.entity.promoextension.PromoExtensionNumericDefectIds;
import ru.yandex.direct.core.entity.turbolanding.service.validation.defects.TurboLandingDefectIds;
import ru.yandex.direct.core.entity.uac.validation.AppInfoDefectIds;
import ru.yandex.direct.core.entity.uac.validation.ContentDefectIds;
import ru.yandex.direct.core.entity.uac.validation.ParseAppInfoUrlDefectIds;
import ru.yandex.direct.core.entity.uac.validation.TrackingUrlDefectIds;
import ru.yandex.direct.core.entity.user.service.validation.UserDefectIds;
import ru.yandex.direct.core.entity.userssegments.service.validation.UsersSegmentDefectIds;
import ru.yandex.direct.core.service.integration.balance.defects.BalanceDefectIds;
import ru.yandex.direct.core.service.integration.balance.defects.BalanceNumericDefectIds;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.core.validation.defects.ids.AdDefectIds;
import ru.yandex.direct.core.validation.defects.ids.CurrencyDefectIds;
import ru.yandex.direct.grid.processing.service.client.validation.ClientMccDefectIds;
import ru.yandex.direct.grid.processing.service.offer.validation.OfferDefectIds;
import ru.yandex.direct.grid.processing.service.userphone.validation.UserPhoneDefects;
import ru.yandex.direct.grid.processing.service.validation.GridDefectIds;
import ru.yandex.direct.validation.defect.ids.CollectionDefectIds;
import ru.yandex.direct.validation.defect.ids.DateDefectIds;
import ru.yandex.direct.validation.defect.ids.DateTimeDefectIds;
import ru.yandex.direct.validation.defect.ids.NumberDefectIds;
import ru.yandex.direct.validation.defect.ids.StringDefectIds;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.validation.result.DefectIds;
import ru.yandex.direct.web.core.security.authentication.WebAuthTranslations;
import ru.yandex.direct.web.entity.uac.validation.UacDefectIds;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.INVALID_FIND_AND_REPLACE_BANNERS_HREF_PARAMS_TEXT;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.paramWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.webDefect;

public class CommonDefectPresentations {

    private CommonDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> commonDefectPresentationRegistry() {
        CommonDefectTranslations translations = CommonDefectTranslations.INSTANCE;
        WebDefectTranslations webTranslations = WebDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()

                .register(DefectIds.INVALID_VALUE, defaultWebDefect())
                .register(DefectIds.INVALID_FORMAT, webDefect(translations.invalidFormatShort()))
                .register(DefectIds.CANNOT_BE_NULL, webDefect(webTranslations.fieldIsRequired()))

                .register(DefectIds.MUST_BE_VALID_ID, defaultWebDefect())
                .register(DefectIds.MUST_BE_VALID_LOGIN, defaultWebDefect())
                .register(DefectIds.LOGIN_CANNOT_BE_PDD, defaultWebDefect())
                .register(DefectIds.UNABLE_TO_DELETE, webDefect(translations.unableToDeleteShort()))

                .register(DefectIds.FORBIDDEN_TO_CHANGE, webDefect(translations.forbiddenToChangeShort()))

                .register(DefectIds.CANNOT_BE_EMPTY, defaultWebDefect())

                .register(DefectIds.MUST_BE_WHOLE_NUMBER, defaultWebDefect())

                .register(DefectIds.ABSENT_REQUIRED_FIELD, defaultWebDefect())

                .register(DefectIds.MUST_BE_EMPTY, webDefect(webTranslations.fieldMustBeEmpty()))

                .register(DefectIds.MUST_BE_NULL, webDefect(webTranslations.fieldMustBeEmpty()))

                .register(DefectIds.OBJECT_NOT_FOUND, webDefect(translations.notFoundShort()))

                .register(DefectIds.INCONSISTENT_STATE, webDefect(translations.inconsistentStateDetailed()))

                .register(DefectIds.INCONSISTENT_STATE_ALREADY_EXISTS, webDefect(translations.alreadyExistsShort()))

                .register(DefectIds.REQUIRED_BUT_EMPTY, defaultWebDefect())
                .register(DefectIds.NO_RIGHTS_CANT_WRITE, defaultWebDefect())

                .register(DefectIds.NO_RIGHTS, webDefect(webTranslations.noRights()))

                .register(DefectIds.CAMPAIGN_STATUS_ARCHIVED,
                        webDefect(translations.badCampaignStatusArchivedCanNotChange()))

                .register(DefectIds.UNKNOWN_PARAMETER, defaultWebDefect())
                .register(DefectIds.ONE_OF_HREF_OR_TURBOLANDING_ID_MUST_BE_NOT_NULL,
                        webDefect(translations.oneOfHrefOrTurboLandingIdMustBeNotNull()))

                .register(DefectIds.METRIKA_RETURNS_RESULT_WITH_ERRORS, defaultWebDefect())
                .register(DefectIds.FAILED_TO_ACQUIRE_LOCK, defaultWebDefect())

                //numbers
                .register(NumberDefectIds.MUST_BE_GREATER_THAN_MIN,
                        webDefect(webTranslations.lessThanMinValue()))
                .register(NumberDefectIds.MUST_BE_GREATER_THAN_OR_EQUAL_TO_MIN,
                        webDefect(webTranslations.lessThanMinValue()))
                .register(NumberDefectIds.MUST_BE_IN_THE_INTERVAL_INCLUSIVE,
                        webDefect(webTranslations.inInterval()))
                .register(NumberDefectIds.MUST_BE_IN_THE_INTERVAL_EXCLUDING_BORDERS,
                        webDefect(webTranslations.inInterval()))
                .register(NumberDefectIds.MUST_BE_LESS_THEN_MAX,
                        webDefect(webTranslations.maxValueExceeded()))
                .register(NumberDefectIds.MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX,
                        webDefect(webTranslations.maxValueExceeded()))
                .register(NumberDefectIds.MUST_BE_NOT_OLDER,
                        webDefect(webTranslations.lessThanMinValue()))
                //strings
                .register(StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX,
                        webDefect(webTranslations.stringLengthMustNotExceed()))

                .register(StringDefectIds.LENGTH_CANNOT_BE_LESS_THAN_MIN,
                        webDefect(webTranslations.stringLengthMustNotLessThan()))

                .register(StringDefectIds.LENGTH_MUST_BE_IN_THE_INTERVAL,
                        webDefect(webTranslations.stringLengthMustBeInInterval()))

                .register(StringDefectIds.CANNOT_BE_EMPTY,
                        webDefect(webTranslations.fieldIsRequired()))

                .register(StringDefectIds.CANNOT_CONTAIN_SYMBOLS, defaultWebDefect())
                .register(StringDefectIds.MUST_CONTAIN_ONLY_SYMBOLS, defaultWebDefect())
                .register(StringDefectIds.MAX_COUNT_WORDS_IN_KEYWORD, defaultWebDefect())
                .register(StringDefectIds.REQUIRED_BUT_EMPTY, defaultWebDefect())

                .register(DefectIds.MUST_CONTAIN_LETTERS, defaultWebDefect())
                .register(DefectIds.MUST_CONTAIN_LETTERS_OR_DIGITS_OR_PUNCTUATIONS, defaultWebDefect())

                //clients
                .register(ClientDefects.Gen.MUST_NOT_BE_FREELANCER, defaultWebDefect())
                .register(ClientDefects.Gen.NOT_APPROPRIATE_ROLE, defaultWebDefect())

                //collections
                .register(CollectionDefectIds.Size.MAX_ELEMENTS_PER_REQUEST, defaultWebDefect())
                .register(CollectionDefectIds.Size.MAX_ELEMENTS_EXCEEDED, defaultWebDefect())
                .register(CollectionDefectIds.Size.SIZE_MUST_BE_IN_INTERVAL,
                        webDefect(webTranslations.collectionSizeMustBeInInterval()))
                .register(CollectionDefectIds.Size.INVALID_COLLECTION_SIZE,
                        webDefect(webTranslations.collectionSizeMustBeInInterval()))
                .register(CollectionDefectIds.Gen.MUST_NOT_CONTAIN_DUPLICATED_OBJECTS,
                        webDefect(webTranslations.duplicateObject()))

                .register(CollectionDefectIds.Gen.MUST_NOT_CONTAIN_DUPLICATED_ELEMENTS,
                        webDefect(webTranslations.duplicateObject()))

                .register(CollectionDefectIds.Size.SIZE_CANNOT_BE_MORE_THAN_MAX,
                        webDefect(webTranslations.collectionSizeExceeded()))
                .register(CollectionDefectIds.Size.SIZE_CANNOT_BE_LESS_THAN_MIN,
                        webDefect(webTranslations.collectionSizeLessThanMin()))
                .register(CollectionDefectIds.Gen.CANNOT_BE_EMPTY,
                        webDefect(webTranslations.collectionCannotBeEmpty()))
                .register(CollectionDefectIds.Gen.MUST_BE_EMPTY,
                        webDefect(webTranslations.collectionMustBeEmpty()))
                .register(CollectionDefectIds.Gen.MUST_BE_IN_COLLECTION,
                        defaultWebDefect())
                .register(CollectionDefectIds.Gen.MUST_NOT_BE_IN_COLLECTION,
                        defaultWebDefect())
                .register(CollectionDefectIds.Gen.CANNOT_CONTAIN_NULLS,
                        defaultWebDefect())

                .register(AdDefectIds.AdIds.REQUIRED_IMPRESSION_RATE_DUE_TO_ADS_HAS_CLOSE_COUNTER,
                        defaultWebDefect())

                //currency amount
                .register(
                        CurrencyDefectIds.Amount.MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX,
                        defaultWebDefect())
                .register(CurrencyDefectIds.Amount.MUST_BE_GREATER_THAN_OR_EQUAL_TO_MIN,
                        defaultWebDefect())
                .register(CurrencyDefectIds.Availability.UNAVAILABLE_CURRENCY,
                        defaultWebDefect())

                //freelancers
                .register(FreelancerDefects.VoidDefects.CLIENT_NOT_FOUND,
                        webDefect(WebAuthTranslations.WEB_AUTH_TRANSLATIONS.userNotFound()))
                .register(FreelancerDefects.VoidDefects.MUST_BE_CLIENT, defaultWebDefect())
                .register(FreelancerDefects.VoidDefects.MUST_BE_FREELANCER,
                        webDefect(webTranslations.mustBeFreelancer()))
                .register(FreelancerDefects.VoidDefects.MUST_HAVE_FREELANCER_CARD,
                        webDefect(webTranslations.mustHaveFreelancerCard()))
                .register(FreelancerDefects.VoidDefects.PROJECT_NOT_FOUND, defaultWebDefect())
                .register(FreelancerDefects.VoidDefects.SKILL_DOES_NOT_EXIST, defaultWebDefect())
                .register(FreelancerDefects.VoidDefects.CLIENT_IS_ALREADY_FREELANCER,
                        webDefect(FreelancerDefectTranslations.INSTANCE.clientIsAlreadyFreelancer()))
                .register(FreelancerDefects.VoidDefects.CLIENT_HAS_WRONG_ROLE, defaultWebDefect())
                .register(FreelancerDefects.VoidDefects.CLIENT_CURRENCY_IS_NOT_CONVERTED, defaultWebDefect())
                .register(FreelancerDefects.VoidDefects.AGENCY_CLIENT_CANT_REQUEST_SERVICE, defaultWebDefect())
                .register(FreelancerDefects.VoidDefects.SOCIAL_CLIENTS_CANT_REQUEST_SERVICE, defaultWebDefect())
                .register(FreelancerDefects.VoidDefects.USERS_COUNT_EXCEEDED, defaultWebDefect())
                .register(FreelancerDefects.VoidDefects.DIRECT_CERTIFICATE_NOT_FOUND,
                        webDefect(FreelancerDefectTranslations.INSTANCE.certificatesNotFound()))
                .register(FreelancerDefects.VoidDefects.NAMES_MUST_BE_SAME_AS_CERT_NAMES,
                        webDefect(FreelancerDefectTranslations.INSTANCE.namesMustBeSameAsCertNames()))
                .register(FreelancerDefects.ProjectsDefects.PROJECTS_ARE_ALREADY_EXIST, defaultWebDefect())
                .register(FreelancerDefects.StatusDefects.TRANSITION_IS_NOT_AVAILABLE, defaultWebDefect())
                .register(FreelancerDefects.FeedbackDefects.FEEDBACK_NOT_FOUND, defaultWebDefect())
                .register(FreelancerDefects.FeedbackDefects.INCORRECT_FEEDBACK_TEXT_SIZE, defaultWebDefect())
                .register(FreelancerDefects.FeedbackDefects.OPERATOR_HAS_NO_PROJECT_WITH_FREELANCER,
                        defaultWebDefect())
                .register(FreelancerDefects.FeedbackDefects.OPERATOR_HAS_WRONG_ROLE, defaultWebDefect())
                .register(FreelancerDefects.FeedbackDefects.OPERATOR_IS_NOT_CHIEF, defaultWebDefect())
                .register(FreelancerDefects.FeedbackDefects.FEEDBACK_ALREADY_EXIST, defaultWebDefect())

                //avatars
                .register(AvatarsDefects.AvatarsClientDefects.SERVER_CONNECTION_ERROR, defaultWebDefect())
                .register(AvatarsDefects.AvatarsClientDefects.UNKNOWN_ERROR, defaultWebDefect())

                //dates
                .register(DateDefectIds.MUST_BE_LESS_THAN_MAX, defaultWebDefect())
                .register(DateDefectIds.MUST_BE_LESS_THAN_OR_EQUAL_TO_MAX, defaultWebDefect())
                .register(DateDefectIds.MUST_BE_GREATER_THAN_MIN, defaultWebDefect())
                .register(DateDefectIds.MUST_BE_GREATER_THAN_OR_EQUAL_TO_MIN, defaultWebDefect())
                .register(DateDefectIds.MUST_BE_IN_THE_INTERVAL_INCLUSIVE, defaultWebDefect())
                .register(DateDefectIds.MUST_BE_IN_THE_INTERVAL_EXCLUDING_BORDERS, defaultWebDefect())
                .register(DateDefectIds.END_DATE_MUST_BE_GREATER_THAN_OR_EQUAL_TO_START_DATE, defaultWebDefect())

                // times
                .register(DateTimeDefectIds.MUST_BE_GREATER_THAN_MIN, defaultWebDefect())
                .register(DateTimeDefectIds.BROAD_HISTORY_TIME_INTERVAL, defaultWebDefect())

                .register(INVALID_FIND_AND_REPLACE_BANNERS_HREF_PARAMS_TEXT, webDefect(
                        webTranslations.findAndReplaceBannerHrefParamsTextCharsMustBeAllowed()))

                //images
                .register(ImageDefectIds.Gen.IMAGE_CONTAINS_ANIMATION, defaultWebDefect())
                .register(ImageDefectIds.Gen.IMAGE_MIME_TYPE_IS_NOT_SUPPORTED, defaultWebDefect())
                .register(ImageDefectIds.Gen.IMAGE_SIZE_IS_NOT_ALLOWED, defaultWebDefect())
                .register(ImageDefectIds.Gen.IMAGE_SIZE_IS_NOT_ALLOWED_MC_BANNER, defaultWebDefect())
                .register(ImageDefectIds.SizesDefects.IMAGE_SIZES_GREATER_THAN_MAX, defaultWebDefect())
                .register(ImageDefectIds.Format.IMAGE_FILE_FORMAT_NOT_ALLOWED, defaultWebDefect())
                .register(ImageDefectIds.Gen.INVALID_IMAGE_FILE, defaultWebDefect())
                .register(ImageDefectIds.Gen.IMAGE_FILE_SIZE_GREATER_THAN_MAX, defaultWebDefect())
                .register(ImageDefectIds.Gen.INVALID_IMAGE_URL, defaultWebDefect())

                //performance_filters
                .register(PerformanceFilterDefects.PerformanceFilterDefectIds.INCONSISTENT_CAMPAIGN_STRATEGY,
                        defaultWebDefect())
                .register(PerformanceFilterDefects.PerformanceFilterDefectIds.FILTER_CONDITIONS_IS_TOO_LONG,
                        defaultWebDefect())
                .register(PerformanceFilterDefects.PerformanceFilterDefectIds.MUST_CONTAIN_ANY_MORE_CONDITIONS,
                        defaultWebDefect())
                .register(PerformanceFilterDefects.PerformanceFilterDefectIds.INVALID_OPERATOR, defaultWebDefect())
                .register(PerformanceFilterDefects.PerformanceFilterDefectIds.UNKNOWN_OPERATOR, defaultWebDefect())
                .register(PerformanceFilterDefects.PerformanceFilterDefectIds.UNKNOWN_FIELD, defaultWebDefect())
                .register(PerformanceFilterDefects.PerformanceFilterNumberDefectIds.FILTER_COUNT_IS_TOO_LARGE,
                        defaultWebDefect())

                // conversion source
                .register(ConversionSourceDefects.Counter.COUNTER_IS_INACCESSIBLE, defaultWebDefect())

                //promoextensions
                .register(PromoExtensionNumericDefectIds.MAX_COUNT_OF_PROMO_EXTENSIONS_CREATED, defaultWebDefect())

                //video segment goals
                .register(UsersSegmentDefectIds.Gen.AD_GROUP_TYPE_NOT_SUPPORTED, defaultWebDefect())
                .register(UsersSegmentDefectIds.Gen.GOAL_TYPE_NOT_SUPPORTED_IN_AD_GROUP, defaultWebDefect())

                .register(InternalAdsAccessGroupDefects.Gen.INVALID_ROLE, defaultWebDefect())

                //dynamictextadtargets
                .register(DynamicTextAdTargetDefectIds.Strings.NUMBER_ARGUMENTS_MUST_BE_FROM_TO, defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.Strings.EXCEEDED_MAX_LENGTH_IN_ARGUMENTS, defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.Strings.INVALID_URL_FORMAT, defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.Strings.INVALID_EMPTY_URL_FORMAT, defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.Strings.INVALID_LETTERS_IN_RULE, defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.Strings.EXCEEDED_MAX_LENGTH_IN_NAME, defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.Strings.INVALID_EMPTY_NAME_FORMAT, defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.Strings.INVALID_LETTERS_IN_NAME, defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.Gen.ALL_PAGE_CONDITION_NOT_WITH_ANOTHER, defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.Gen.AD_GROUP_NOT_FOUND, defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.Gen.NOT_ACCEPTABLE_AD_GROUP_TYPE, defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.Num.MAX_COUNT_IN_ADGROUP, defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.Gen.DUPLICATE_RULES_IN_CONDITION, defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.Num.INVALID_FORMAT_WEBPAGE_CONDITION, defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.Num.NUMBER_OF_RULES_MUST_BE_FROM_TO, defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.Gen.ALREADY_SUSPENDED, defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.Gen.IS_NOT_SUSPENDED, defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.IdParametrized.DYNAMIC_TEXT_AD_TARGET_NOT_FOUND_IN_CAMPAIGN,
                        defaultWebDefect())
                .register(DynamicTextAdTargetDefectIds.IdParametrized.DYNAMIC_TEXT_AD_TARGET_NOT_FOUND_IN_AD_GROUP,
                        defaultWebDefect())


                .register(MinusPhraseDefectIds.Number.NEGATIVE_KEYWORD_SETS_LIMIT_EXCEEDED,
                        paramWebDefect(di -> MinusPhraseDefectTranslations.INSTANCE.negativeKeywordSetsLimitExceededDetailed(di.getDefect().params().getMax().intValue())))

                //balance
                .register(BalanceDefectIds.INVALID_PROMO_CODE, defaultWebDefect())
                .register(BalanceDefectIds.PROMOCODE_WRONG_CLIENT, defaultWebDefect())
                .register(BalanceDefectIds.UNIQUE_URLS_PROMOCODE, defaultWebDefect())
                .register(BalanceNumericDefectIds.INVALID_MINIMAL_QTY, defaultWebDefect())

                // organizations
                .register(OrganizationDefectIds.Gen.ORGANIZATION_NOT_FOUND,
                        webDefect(OrganizationDefectTranslations.INSTANCE.organizationNotFound()))
                .register(OrganizationDefectIds.Gen.INVALID_PREFER_V_CARD_OVER_PERMALINK,
                        webDefect(OrganizationDefectTranslations.INSTANCE.invalidPreferVCardOverPermalink()))
                .register(OrganizationDefectIds.Gen.HAS_NO_ACCESS_TO_ORGANIZATION,
                        webDefect(OrganizationDefectTranslations.INSTANCE.hasNoAccessToOrganization()))
                .register(OrganizationDefectIds.Gen.EITHER_PERMALINK_OR_CHAIN_CAN_BE_FILLED,
                        webDefect(OrganizationDefectTranslations.INSTANCE.eitherPermalinkOrChainCanBeFilled()))
                .register(OrganizationDefectIds.Statuses.INVALID_ORGANIZATION_STATUS,
                        paramWebDefect(di -> OrganizationDefectTranslations.INSTANCE.invalidOrganizationStatus(
                                di.getValue().toString())))

                // client phones
                .register(ClientPhoneDefects.Ids.PHONE_COUNTRY_NOT_ALLOWED, defaultWebDefect())

                // calltracking settings
                .register(CalltrackingSettingDefects.Ids.NO_WRITE_PERMISSIONS_ON_COUNTER, defaultWebDefect())
                .register(CalltrackingSettingDefects.Ids.COUNTER_NOT_AVAILABLE_FOR_CLIENT, defaultWebDefect())
                .register(CalltrackingSettingDefects.Ids.FORBIDDEN_DOMAIN, defaultWebDefect())

                //users
                .register(UserDefectIds.Gen.USER_NOT_FOUND, defaultWebDefect())
                .register(UserDefectIds.Gen.USER_IS_NOT_REPRESENTATIVE, defaultWebDefect())
                .register(UserDefectIds.Gen.USER_IS_BLOCKED, defaultWebDefect())
                .register(UserDefectIds.Gen.USER_ASSOCIATED_WITH_ANOTHER_CLIENT, defaultWebDefect())
                .register(UserDefectIds.Gen.USER_HAS_CARD_PAYMENT_METHOD, defaultWebDefect())
                .register(UserDefectIds.Gen.USER_HAS_NOT_VALID_NAME, defaultWebDefect())
                .register(UserDefectIds.Gen.USER_HAS_NOT_VALID_EMAIL, defaultWebDefect())
                .register(UserDefectIds.Gen.BALANCE_USER_ASSOCIATED_WITH_ANOTHER_CLIENT, defaultWebDefect())
                .register(UserDefectIds.Gen.USER_HAS_ACTIVE_AUTOPAY, defaultWebDefect())
                .register(UserDefectIds.Gen.CHIEF_DELETION_PROHIBITED, defaultWebDefect())
                .register(UserDefectIds.Gen.USER_MUST_BE_MANAGER, defaultWebDefect())
                .register(UserDefectIds.Gen.USER_MUST_BE_MANAGER_IN_BALANCE, defaultWebDefect())
                .register(UserDefectIds.Gen.USER_CANT_BE_UNBLOCKED, defaultWebDefect())
                .register(UserDefectIds.Gen.USER_HAS_NO_AVAILABLE_CURRENCIES, defaultWebDefect())

                .register(GridDefectIds.Str.INVALID_CLIENT_MEASURER, defaultWebDefect())

                //content promotion
                .register(ContentPromotionDefectIds.NumberDefectIds.NOT_ENOUGH_CARDS_IN_EXISTING_COLLECTION,
                        paramWebDefect(di -> translations.notEnoughCardsinExistingCollection(di.getDefect().params().getMin().intValue())))
                .register(ContentPromotionDefectIds.NumberDefectIds.NOT_ENOUGH_CARDS_IN_NEW_COLLECTION,
                        paramWebDefect(di -> translations.notEnoughCardsInNewCollection(di.getDefect().params().getMin().intValue())))
                .register(ContentPromotionDefectIds.GeneralDefectIds.CONTENT_PROMOTION_INACCESSIBLE,
                        webDefect(translations.contentInaccessibleGetmeta()))
                .register(ContentPromotionDefectIds.GeneralDefectIds.CONTENT_PROMOTION_NOT_FOUND,
                        webDefect(translations.contentNotFoundGetmeta()))
                .register(ContentPromotionDefectIds.GeneralDefectIds.CONTENT_PROMOTION_TYPE_IS_NOT_SUPPORTED,
                        webDefect(translations.contentTypeIsNotSupported()))
                .register(TurboLandingDefectIds.MODERATION_REQUIRED_ATTRIBUTE_CANT_BE_CHANGED, defaultWebDefect())
                .register(TurboLandingDefectIds.INCONSISTENT_STATE_OF_MODERATION_STATUS, defaultWebDefect())

                // verified phones
                .register(UserPhoneDefects.PhoneDefects.EMPTY_PHONE, defaultWebDefect())
                .register(UserPhoneDefects.PhoneDefects.INVALID_PHONE, defaultWebDefect())
                .register(UserPhoneDefects.PhoneDefects.SMS_LIMIT_EXCEEDED, defaultWebDefect())
                .register(UserPhoneDefects.CodeDefects.INVALID_CODE, defaultWebDefect())
                .register(UserPhoneDefects.CodeDefects.CONFIRMATIONS_LIMIT_EXCEEDED, defaultWebDefect())
                .register(UserPhoneDefects.GeneralDefects.UNEXPECTED_ERROR, defaultWebDefect())
                .register(UserPhoneDefects.GeneralDefects.INTERNAL_PASSPORT_ERROR, defaultWebDefect())
                .register(UserPhoneDefects.GeneralDefects.TOO_MANY_REQUESTS, defaultWebDefect())
                .register(DefectIds.PHONE_MUST_BE_VERIFIED, defaultWebDefect())
                .register(UserPhoneDefects.PhoneIdDefects.ALREADY_BIND_AND_SECURE, defaultWebDefect())

                .register(DefectIds.PROMOCODE_DOMAIN_OR_CLIENT_DOES_NOT_MATCH, defaultWebDefect())
                .register(DefectIds.PROMOCODE_CLIENT_DOES_NOT_MATCH, defaultWebDefect())
                .register(DefectIds.PROMOCODE_CLIENT_DOMAIN_DOES_NOT_MATCH, defaultWebDefect())
                .register(DefectIds.PROMOCODE_CLIENT_HAS_MULTIPLE_DOMAINS, defaultWebDefect())

                // offer
                .register(OfferDefectIds.UNABLE_TO_FILTER, defaultWebDefect())

                // uac
                .register(AppInfoDefectIds.Gen.APP_INFO_NOT_FOUND, defaultWebDefect())
                .register(TrackingUrlDefectIds.Gen.INVALID_TRACKING_URL, defaultWebDefect())
                .register(TrackingUrlDefectIds.Gen.INVALID_IMPRESSION_URL, defaultWebDefect())
                .register(TrackingUrlDefectIds.Gen.TRACKING_URL_WRONG_REDIRECT, defaultWebDefect())
                .register(TrackingUrlDefectIds.Gen.CANNOT_MAKE_IMPRESSION_URL, defaultWebDefect())
                .register(UacDefectIds.Gen.INVALID_AVATARS_URL, defaultWebDefect())
                .register(UacDefectIds.Gen.INVALID_TYPE_OF_AVATARS_URL, defaultWebDefect())
                .register(ContentDefectIds.Gen.SIZE_OF_IMAGE_CONTENTS_CANNOT_BE_MORE_THAN_MAX, defaultWebDefect())
                .register(ContentDefectIds.Gen.SIZE_OF_VIDEO_CONTENTS_CANNOT_BE_MORE_THAN_MAX, defaultWebDefect())
                .register(ContentDefectIds.Canvas.INVALIDATED_BY_CANVAS, defaultWebDefect())
                .register(ParseAppInfoUrlDefectIds.Gen.INVALID_APP_STORE_URL, defaultWebDefect())
                .register(UacDefectIds.Gen.SEGMENT_CREATION_FROM_FILE_FAILED, defaultWebDefect())
                .register(UacDefectIds.Str.YA_AUDIENCE_TYPED_ERROR, defaultWebDefect())
                .register(ParseAppInfoUrlDefectIds.Gen.INVALID_APP_ID, defaultWebDefect())
                .register(ParseAppInfoUrlDefectIds.Gen.INVALID_GOOGLE_PLAY_URL, defaultWebDefect())
                .register(ParseAppInfoUrlDefectIds.Gen.INVALID_ITUNES_URL, defaultWebDefect())
                .register(ParseAppInfoUrlDefectIds.Gen.INVALID_URL, defaultWebDefect())
                .register(ParseAppInfoUrlDefectIds.Gen.MULTIPLE_PARAMS, defaultWebDefect())

                // mobileapp
                .register(MobileAppDefects.Gen.CAN_NOT_CHANGE_TRACKING_SYSTEM_IN_CPI_CAMPAIGN, defaultWebDefect())
                .register(MobileAppDefects.Gen.CAN_NOT_CHANGE_TRACKING_SYSTEM_WITH_UNTRACKABLE_BANNER_HREF,
                        defaultWebDefect())

                // hypergeo
                .register(HyperGeoDefectIds.Gen.COUNT_OF_SEGMENTS_MUST_BE_IN_INTERVAL, defaultWebDefect())

                // clientmcc
                .register(ClientMccDefectIds.Gen.CLIENT_ALREADY_LINKED, defaultWebDefect())
                .register(ClientMccDefectIds.Gen.MCC_LINK_NOT_FOUND, defaultWebDefect())
                .register(ClientMccDefectIds.Gen.REQUEST_NOT_FOUND, defaultWebDefect())
                .register(ClientMccDefectIds.Gen.CLIENT_NOT_ALLOWED, defaultWebDefect())
                .register(ClientMccDefectIds.Num.MCC_REQUESTS_LIMIT_EXCEEDED, defaultWebDefect())
                .register(ClientMccDefectIds.Num.MANAGED_CLIENTS_LIMIT_EXCEEDED, defaultWebDefect())

                // generation
                .register(GenerationDefectIds.CAMPAIGN_WITHOUT_HREF, defaultWebDefect())
                .register(GenerationDefectIds.BAD_CAMPAIGN_HREF, defaultWebDefect())
                .register(GenerationDefectIds.EMPTY_SEARCH_QUERY_API_RESPONSE, defaultWebDefect())
                .register(GenerationDefectIds.CAMPAIGN_WITHOUT_PERMALINK, defaultWebDefect())
                .register(GenerationDefectIds.PERMALINK_WITHOUT_GEO, defaultWebDefect())
                .register(GenerationDefectIds.PERMALINK_WITHOUT_SUITABLE_GEO, defaultWebDefect())
                .register(GenerationDefectIds.COUNTERS_NOT_FOUND, defaultWebDefect())
                .register(GenerationDefectIds.DOMAIN_DISABLED, defaultWebDefect())
                .register(GenerationDefectIds.AD_GROUP_WITHOUT_KEYWORDS, defaultWebDefect())
                .register(GenerationDefectIds.IMAGE_SEARCH_API_WITHOUT_QUERY, defaultWebDefect())
                .register(GenerationDefectIds.EMPTY_IMAGE_SEARCH_API_RESPONSE, defaultWebDefect())
                .register(GenerationDefectIds.SITELINKS_NOT_FOUND, defaultWebDefect())
                .register(GenerationDefectIds.SITELINKS_FOUND_ONLY_FOR_COMMON_PAGE, defaultWebDefect())
                .register(GenerationDefectIds.SITELINKS_FOUND_FOR_PARENT_PAGE, defaultWebDefect())
                .register(GenerationDefectIds.RICH_CONTENT_API_USE_ZORA, defaultWebDefect())
                .register(GenerationDefectIds.SPRAV_API_ERROR, defaultWebDefect())
                .register(GenerationDefectIds.RICH_CONTENT_API_ERROR, defaultWebDefect())
                .register(GenerationDefectIds.SEARCH_QUERY_API_ERROR, defaultWebDefect())
                .register(GenerationDefectIds.IMAGE_SEARCH_API_ERROR, defaultWebDefect())
                .register(GenerationDefectIds.METRIKA_API_ERROR, defaultWebDefect())
                .register(GenerationDefectIds.BANGEN_PROXY_API_ERROR, defaultWebDefect())

                //feed offers
                .register(FeedOfferDefects.FeedOfferDefectIds.NO_OFFERS, defaultWebDefect())
                .register(FeedOfferDefects.FeedOfferDefectIds.UNKNOWN_OFFER_ID, defaultWebDefect())
                .register(FeedOfferDefects.FeedOfferDefectIds.OFFER_ID_NOT_UNIQUE, defaultWebDefect())
                .register(FeedOfferDefects.FeedOfferDefectIds.CLIENT_NOT_EXIST_IN_GRUT, defaultWebDefect())
                .register(FeedOfferDefects.FeedOfferDefectIds.INVALID_HREF, defaultWebDefect())
                .register(FeedOfferDefects.FeedOfferDefectIds.HREF_NOT_UNIQUE, defaultWebDefect())
                .register(FeedOfferDefects.FeedOfferDefectIds.NO_IMAGES, defaultWebDefect())
                .register(FeedOfferDefects.FeedOfferNumberDefectIds.OFFER_COUNT_IS_TOO_LARGE, defaultWebDefect())
                .register(FeedOfferDefects.FeedOfferNumberDefectIds.IMAGE_COUNT_IS_TOO_LARGE, defaultWebDefect())
                .register(FeedOfferDefects.FeedOfferNumberDefectIds.OLD_PRICE_LESS_OR_EQUAL_THAN_CURRENT,
                        defaultWebDefect())

                //href params
                .register(HrefParamsDefectIds.GeneralDefectIds.HREF_WITH_PARAMS_INVALID, defaultWebDefect())
                .register(HrefParamsDefectIds.NumberDefectIds.HREF_PARAMS_TOO_LONG, defaultWebDefect())

                // multipart files
                .register(DefectIds.FILE_MIME_TYPE_IS_NOT_SUPPORTED, defaultWebDefect())
                .register(DefectIds.NO_CONTENT_TYPE, defaultWebDefect())
                .build();
    }
}

