package ru.yandex.direct.web.validation;

import ru.yandex.direct.grid.processing.service.validation.GridDefectIds;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.grid.processing.exception.GdExceptions.ACCESS_DENIED;
import static ru.yandex.direct.grid.processing.exception.GdExceptions.NO_RIGHTS;
import static ru.yandex.direct.grid.processing.exception.GdExceptions.TYCOON_SERVICE_UNAVAILABLE;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.DATES_FROM_NOT_AFTER_TO;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.INVALID_MONTH_FORMAT;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.INVALID_UNION;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.MUST_BE_MUTUALLY_EXCLUSIVE;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.MUST_BE_SAME_NULL_STATE;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.MUST_CONTAIN_NON_NULL_PROPS;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.OfflineReport.MAX_REPORT_PERIOD;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.OfflineReport.MIN_MONTH_FROM;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.Pixels.INVALID_AUDIENCE_PIXEL_FORMAT;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.Pixels.INVALID_AUDIT_PIXEL_FORMAT;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.TimeTarget.INVALID_TIME_BOARD_FORMAT;
import static ru.yandex.direct.grid.processing.service.validation.GridDefectIds.UNSUPPORTED_GROUP_TYPE;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect;

public class GridDefectPresentations {

    private GridDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> gridDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(MUST_BE_MUTUALLY_EXCLUSIVE, defaultWebDefect())
                .register(MUST_BE_SAME_NULL_STATE, defaultWebDefect())
                .register(DATES_FROM_NOT_AFTER_TO, defaultWebDefect())
                .register(MUST_CONTAIN_NON_NULL_PROPS, defaultWebDefect())
                .register(UNSUPPORTED_GROUP_TYPE, defaultWebDefect())
                .register(ACCESS_DENIED, defaultWebDefect())
                .register(NO_RIGHTS, defaultWebDefect())
                .register(INVALID_MONTH_FORMAT, defaultWebDefect())
                .register(MIN_MONTH_FROM, defaultWebDefect())
                .register(MAX_REPORT_PERIOD, defaultWebDefect())
                .register(INVALID_AUDIENCE_PIXEL_FORMAT, defaultWebDefect())
                .register(INVALID_AUDIT_PIXEL_FORMAT, defaultWebDefect())
                .register(INVALID_UNION, defaultWebDefect())
                .register(INVALID_TIME_BOARD_FORMAT, defaultWebDefect())
                .register(TYCOON_SERVICE_UNAVAILABLE, defaultWebDefect())
                .register(GridDefectIds.Ids.GOAL_IDS_FROM_ORDER_BY_NOT_FOUND_IN_STAT_REQUIREMENTS,
                        defaultWebDefect())
                .build();
    }
}
