package ru.yandex.direct.web.validation;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;

public interface WebDefectTranslations extends TranslationBundle {

    WebDefectTranslations INSTANCE = I18NBundle.implement(WebDefectTranslations.class);

    @MessageFormatStub("Минус-фраза содержится в ключевой фразе")
    Translatable minusKeywordIsIncludedInKeyword();

    @MessageFormatStub("Превышен максимальный размер списка")
    Translatable collectionSizeExceeded();

    @MessageFormatStub("Количество элементов списка не может быть меньше минимального")
    Translatable collectionSizeLessThanMin();

    @MessageFormatStub("Список не может быть пустым")
    Translatable collectionCannotBeEmpty();

    @MessageFormatStub("Список должен быть пустым")
    Translatable collectionMustBeEmpty();

    @MessageFormatStub("Неверное значение")
    Translatable invalidValue();

    @MessageFormatStub("Объект не найден")
    Translatable objectNotFound();

    @MessageFormatStub("Неверное значение поля")
    Translatable invalidValueDetailed();

    @MessageFormatStub("Необходимо заполнить поле")
    Translatable fieldIsRequired();

    @MessageFormatStub("Поле должно быть пустым")
    Translatable fieldMustBeEmpty();

    @MessageFormatStub("Объект с указанными характеристиками уже существует")
    Translatable alreadyExists();

    @MessageFormatStub("Максимально допустимое значение превышено")
    Translatable maxValueExceeded();

    @MessageFormatStub("Указанное значение меньше допустимого")
    Translatable lessThanMinValue();

    @MessageFormatStub("Значение поля не попадает в допустимый интервал")
    Translatable inInterval();

    @MessageFormatStub("Превышена максимально допустимая длина строки")
    Translatable stringLengthMustNotExceed();

    @MessageFormatStub("Длина строки меньше минимально допустимой")
    Translatable stringLengthMustNotLessThan();

    @MessageFormatStub("Длина строки не входит в допустимый интервал")
    Translatable stringLengthMustBeInInterval();

    @MessageFormatStub("Количество элементов не входит в допустимый интервал")
    Translatable collectionSizeMustBeInInterval();

    @MessageFormatStub("Нельзя указать одинаковые значения")
    Translatable duplicateObject();

    @MessageFormatStub("Недостаточно прав для выполнения операции")
    Translatable noRights();

    @MessageFormatStub("Не найден фрилансер с таким идентификатором")
    Translatable mustBeFreelancer();

    @MessageFormatStub("Не заполнены обязательные поля карточки специалиста")
    Translatable mustHaveFreelancerCard();

    @MessageFormatStub("Указаны неверные символы")
    Translatable findAndReplaceBannerHrefParamsTextCharsMustBeAllowed();
}
