package ru.yandex.direct.web.validation.kernel;

import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.validation.presentation.DefectPresentationProvider;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;

/**
 * Промежуточное состояние представления дефекта,
 * которое содержит соответствующий {@link Translatable},
 * но еще не содержит конечного перевода. Без такой промежуточной
 * сущности при регистрации дефектов в каждый провайдер
 * {@link DefectPresentationProvider}
 * потребовалось бы передавать сервис для перевода {@link Translatable} в строку.
 */
public class TranslatableWebDefect {

    private Translatable translatable;
    private DefectInfo<? extends Defect> defectInfo;

    public TranslatableWebDefect(Translatable text, DefectInfo<? extends Defect> defectInfo) {
        this.translatable = text;
        this.defectInfo = defectInfo;
    }

    public Translatable getTranslatable() {
        return translatable;
    }

    public DefectInfo<? extends Defect> getDefectInfo() {
        return defectInfo;
    }
}

