package ru.yandex.direct.web.validation.kernel;

import java.util.function.Function;

import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.validation.presentation.DefectPresentationProvider;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;
import ru.yandex.direct.web.validation.WebDefectTranslations;

public class WebDefectPresentationProviders {

    public static <T> DefectPresentationProvider<T, TranslatableWebDefect> webDefect(
            Translatable errTranslatable) {
        return paramWebDefect(di -> errTranslatable);
    }

    public static <T> DefectPresentationProvider<T, TranslatableWebDefect> defaultWebDefect() {
        return webDefect(WebDefectTranslations.INSTANCE.invalidValue());
    }

    public static <T> DefectPresentationProvider<T, TranslatableWebDefect> paramWebDefect(
            Function<DefectInfo<? extends Defect<T>>, Translatable> translatableProviderFunction) {
        return defectInfo -> {
            Translatable errTranslatable = translatableProviderFunction.apply(defectInfo);
            return new TranslatableWebDefect(errTranslatable, defectInfo);
        };
    }
}
