package ru.yandex.direct.web.validation.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.core.model.WebResponse;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class ValidationResponse implements WebResponse {
    private WebValidationResult webValidationResult;

    public ValidationResponse(WebValidationResult webValidationResult) {
        this.webValidationResult = webValidationResult;
    }

    @JsonProperty("validation_result")
    public WebValidationResult validationResult() {
        return webValidationResult;
    }

    @Override
    public boolean isSuccessful() {
        return false;
    }
}
