package ru.yandex.direct.web.validation.model;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import static java.util.Arrays.asList;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class WebValidationResult {

    @JsonProperty("errors")
    private List<WebDefect> errors = new ArrayList<>();

    @JsonProperty("warnings")
    private List<WebDefect> warnings = new ArrayList<>();

    public List<WebDefect> getErrors() {
        return errors;
    }

    public WebValidationResult addErrors(List<WebDefect> errors) {
        this.errors.addAll(errors);
        return this;
    }

    public WebValidationResult addErrors(WebDefect... errors) {
        this.errors.addAll(asList(errors));
        return this;
    }

    public List<WebDefect> getWarnings() {
        return warnings;
    }

    public WebValidationResult addWarnings(List<WebDefect> warnings) {
        this.warnings.addAll(warnings);
        return this;
    }

    public WebValidationResult addWarnings(WebDefect... warnings) {
        this.warnings.addAll(asList(warnings));
        return this;
    }
}
