class SimpleToolDescription extends React.Component {
    constructor(props) {
        super(props);

        this.setTool = this.setTool.bind(this);
    }

    setTool(event) {
        if (event.ctrlKey || event.metaKey) {
            return;
        }
        this.props.onSetTool(this.props.label);
    }

    render() {
        return (
            <a href={"#" + this.props.label} onClick={this.setTool}>{this.props.name}</a>
        );
    }
}

class Category extends React.Component {
    render() {
        return (
            <div className="col-sm-12">
                <h4>{this.props.name}</h4>
                <ul>{this.props.tools.map((tool) =>
                    <li key={tool.label}>
                        <SimpleToolDescription name={tool.name} label={tool.label} description={tool.description}
                                               onSetTool={this.props.onSetTool}/>
                    </li>)}
                </ul>
            </div>
        );
    }
}

class CategoriesList extends React.Component {
    render() {
        if (this.props.items === null) {
            return (<div><p>Loading...</p></div>)
        }

        return (
            <div>{this.props.items.map((category) =>
                <div key={category.name} className="row">
                    <Category name={category.name} tools={category.items} onSetTool={this.props.onSetTool}/>
                </div>)}
            </div>
        );
    }
}
