const csrfCookieName = "_direct_csrf_token";
const baseUrl = "/internal_tools";

function getBaseUrl() {
    return baseUrl + "/";
}

function categoriesListUrl() {
    return baseUrl + "/categories/list";
}

function toolUrl(label) {
    return baseUrl + "/tools/" + label;
}

function toolActionUrl(label, action) {
    return toolUrl(label) + "/" + action;
}

function toolGetUrl(label) {
    return toolActionUrl(label, "get");
}

function toolReadUrl(label) {
    return toolActionUrl(label, "read");
}

function toolWriteUrl(label) {
    return toolActionUrl(label, "write");
}

function toolFileUploadUrl(label) {
    return toolActionUrl(label, "upload_file");
}

function request(url, data, onSuccess, post, onError, file) {
    if (!onError) {
        onError = handleError;
    }

    var requestSettings = {
        url: url,
        success: onSuccess,
        error: onError
    };

    if (post && data) {
        data['currentHost'] = window.location.host;
        requestSettings.headers = {
            "X-CSRF-TOKEN": getCsrfToken(),
        };
        if (file) {
            requestSettings.data = data;
            requestSettings.processData = false;
            requestSettings.contentType = false;
        } else {
            requestSettings.data = JSON.stringify(data);
            requestSettings.contentType = 'application/json; charset=UTF-8';
            requestSettings.headers['Accept'] = requestSettings.contentType;
        }
        requestSettings.method = "POST";
    } else if (data) {
        requestSettings.data = data;
    }
    $.ajax(requestSettings);
}

function getCsrfToken() {
    return Cookies.get(csrfCookieName);
}

function handleError(data) {
    alert("Unhandled error");
}
