class Notification extends React.Component {
    constructor(props) {
        super(props);
        this.dismiss = this.dismiss.bind(this);
    }

    dismiss() {
        this.props.onDismiss(this.props.identifier);
    }

    render() {
        return (
            <div className="alert alert-danger alert-dismissible" role="alert">
                <button type="button" className="close" onClick={this.dismiss}><span aria-hidden="true">&times;</span></button>
                <strong>{this.props.title}</strong> {this.props.message}
            </div>
        );
    }
}

class NotificationsContainer extends React.Component {
    render() {
        return (
            <div className="row">
                <div className="col-sm-12">
                    {this.props.items.map(notification =>
                        <div key={notification.key}>
                            <Notification title={notification.title} message={notification.message} identifier={notification.key} onDismiss={this.props.onDismiss}/>
                        </div>
                    )}
                </div>
            </div>
        );
    }
}
