# -*- coding: utf-8 -*-

import logging
import os
import requests
import tempfile
import yatest.common
from ut_utils import PythonTest


class Test(PythonTest):
    @classmethod
    def logger(cls):
        return logging.getLogger("test_logger")

    @classmethod
    def tar_paths(cls):
        return ["direct/web/yandex-direct-web.tar"]

    @classmethod
    def java_class_name(cls):
        return 'ru.yandex.direct.web.DirectWebApp'

    @classmethod
    def setup_class(cls):
        cls.tmp_token_file = tempfile.NamedTemporaryFile()
        cls.tmp_token_file.file.write(b"super_secret")
        cls.tmp_token_file.file.flush()
        super(Test, cls).setup_class()

    @classmethod
    def teardown_class(cls):
        os.unlink(cls.tmp_token_file.name)
        super(Test, cls).teardown_class()

    @classmethod
    def java_args(cls):
        return [
            "-Dyandex.environment.type=production",
            "-Ddb_config=classpath:///db-config.db_testing.json",
            "-Dnetwork_config=classpath:///network-config.allow-all.json",
            "-Dsendmail.yservice_salt_file_url=classpath:sendmail-yservice-salt.txt",
            "-Dsendmail.hmac_salt_file_url=classpath:sendmail-hmac-salt.txt",
            "-Dmds.direct_files.token_file_url=classpath:///mds-auth-testing.txt",
            "-Ddssclient.user_credentials_file_url=classpath:dss-user-credentials.json",
            "-Ddssclient.client_credentials_file_url=classpath:dss-client-credentials.json",
            "-Dtvm.secret=memory://top_secret",
            "-Dtvm.enabled=false",
            "-Dcanvas.file=" + cls.tmp_token_file.name,
            "-Dturbo_landings.file=" + cls.tmp_token_file.name,
            "-Dredis_cache.name=redis",
            "-Djetty.port=" + str(cls.get_server_port()),
            "-Djetty.ssl_port=0",
            "-DLOG_ROOT=" + yatest.common.output_path(""),
            "-Dmediascope_client.settings_salt_token_path=memory://m_secret",
            "-Dmediascope_client.client_id_path=memory://direct",
            "-Dmediascope_client.client_secret_path=memory://password",
            "-Dbannerstorage_api.url=http://not_real_host",
            "-Dbannerstorage_api.token=top_secret",
            "-Dstartrek.robot_direct_daas.token_file=memory://secret_token",
            "-Dobject_api.service_holder.token=memory://fake_secret",
            "-Dmds-s3.token_file_url=",
            "-Dconversion_center.encryption.secret=memory://fake_secret",
            ]

    @classmethod
    def get_server_start_timeout(cls):
        return 300

    def test_alive(self):
        """ alive отвечает либо 200 OK, либо 500 и одна строка с ошибкой """
        resp = requests.get(self.get_base_url() + 'alive')
        if resp.ok:
            assert resp.text == "ok"
        else:
            assert resp.status_code == 500

    def test_admin_version(self):
        resp = requests.get(self.get_base_url() + "admin?action=version")
        assert resp.status_code == 200
        assert 'url' in resp.json()

    def test_swagger_api(self):
        resp = requests.get(self.get_base_url() + "docs/api")
        assert resp.status_code == 200
        # описание контроллера из ApiOperation
        assert u'Add minus keywords for campaigns' not in resp.text
        # информация из ApiModelProperty
        assert u'"readOnly": true' not in resp.text
        # описание поля модели из ApiModelProperty
        assert u'при type == audience' not in resp.text
        # информация из ApiModel
        assert u'Список добавляемых минус-фраз для одной кампании' not in resp.text
        # нет тестовых контроллеров
        assert u'defect/list' not in resp.text
