/*globals AmCharts*/
(function () {
    'use strict';

    /**
     * @private
     * @param {string} formattedNumber
     * @return {number}
     */
    function _getLabelPrecision(formattedNumber) {
        var decimalSeparator = formattedNumber && formattedNumber.indexOf('.') ? '.' : ',';
        var precision = formattedNumber.split(decimalSeparator)[1];
        if (precision) {
            precision = precision.length;
            if (precision % 3) {
                precision = precision + (3 - precision % 3);
            }
        } else {
            precision = -1;
        }
        return precision;
    }

    /**
     * @private
     * @param {object} formatter
     * @param {string} formatter.decimalSeparator
     * @param {string} formatter.fractionalSeparator
     * @param {string} formatter.thousandsSeparatorarator
     * @return {function}
     */
    function _getLabelFunction(formatter) {
        /**
         * @public
         * @param {number} number
         * @param {string} formattedNumber
         * @return {string}
         */
        return function (number, formattedNumber) {
            return BEMHTML.apply({
                tag: '',
                block: 'b-formatter',
                mods: {type: 'float'},
                content: number,
                formatter: {
                    precision: _getLabelPrecision(formattedNumber),
                    decimalSeparator: formatter.decimalSeparator,
                    fractionalSeparator: formatter.fractionalSeparator,
                    thousandsSeparatorarator: formatter.thousandsSeparator
                }
            });
        };
    }

    BEM.DOM.decl('b-chart', {

        onSetMod: {
            js: function () {
                AmCharts.useUTC = true;
                AmCharts.shortMonthNames = [
                    BEM.I18N('b-chart', 'Jan'), BEM.I18N('b-chart', 'Feb'), BEM.I18N('b-chart', 'Mar'),
                    BEM.I18N('b-chart', 'Apr'), BEM.I18N('b-chart', 'May'), BEM.I18N('b-chart', 'Jun'),
                    BEM.I18N('b-chart', 'Jul'), BEM.I18N('b-chart', 'Aug'), BEM.I18N('b-chart', 'Sep'),
                    BEM.I18N('b-chart', 'Oct'), BEM.I18N('b-chart', 'Nov'), BEM.I18N('b-chart', 'Dec')
                ];
                this._renderChart();
            }
        },

        destruct: function () {
            if (this.chart) {
                this.chart.clear();
            }
            this.__base.apply(this, arguments);
        },

        invalidateSize: function () {
            var _this = this;
            try {
                this._chart.invalidateSize();
            } catch (e) {
                _this.domElem.hide();
            }
        },

        _renderChart: function () {
            var valueAxes = this.params.graphs.map(function (g, i) {
                return {
                    id: 'v' + i,
                    axisColor: g.color,
                    position: g.axisPos,
                    gridAlpha: 0,
                    labelFunction: _getLabelFunction(this.params)
                };
            }, this);

            var graphs = this.params.graphs.map(function (g, i) {
                return {
                    valueAxis: 'v' + i,
                    title: g.title,
                    valueField: g.key,
                    descriptionField: g.descriptionField,
                    lineColor: g.color,
                    balloonText: '[[title]]: [[description]]'
                };
            }, this);

            var dataProvider = this.params.data.map(function (item) {
                return item;
            });

            var events = this.params.events || [];

            this._chart = AmCharts.makeChart(this.params.name, {
                type: 'serial',
                theme: 'none',
                pathToImages: '/js/amcharts/images/',

                categoryField: 'date',
                categoryAxis: {
                    parseDates: true,
                    minPeriod: this.params.minPeriod,
                    guides: events.map(function (event) {
                        return {
                            date: new Date(event.date),
                            lineColor: '#4572A7',
                            lineAlpha: 1,
                            lineThickness: 1
                        };
                    }).filter(Boolean)
                },
                chartCursor: {
                    cursorPosition: 'mouse',
                    categoryBalloonDateFormat: this.params.minPeriod
                },
                chartScrollbar: {},
                dataDateFormat: 'YYYY-MM-DD',
                dataProvider: dataProvider,
                graphs: graphs,
                legend: {
                    valueText: ''
                },
                valueAxes: valueAxes,
            });
        }
    });
})();
