(function () {
    'use strict';
    BEM.DOM.decl('b-db-switcher', {

        onSetMod: {
            js: function () {
                this._initBlock();
                this._addListeners();
                this._refreshDOM();
            }
        },

        destruct: function () {
            this._bFormRadio.un('change', this._onRadioChange, this);
        },

        _initBlock: function () {
            // {i-route}
            this._iRoute = BEM.blocks['i-route'].getInstance();
            // {b-form-radio}
            this._bFormRadio = this.findBlockInside('b-form-radio');
        },

        _refreshDOM: function () {
            var params = this._iRoute.get();
            this.val(params.db);
        },

        _addListeners: function () {
            this._bFormRadio.on('change', this._onRadioChange, this);
        },

        _onRadioChange: function () {
            if (this._val !== this.val()) {
                this._iRoute.load({db: this.val()});
            }
        },

        val: function (value) {
            if (value !== undefined) {
                this._val = value;
                this._bFormRadio.val(value);
            } else {
                return this._bFormRadio.val();
            }
       }
    });
})();
