/**
 * Direct promo block
 *
 * @author @nafania
 **/
(function () {
    'use strict';
    BEM.DOM.decl('b-direct-promo', {

        onSetMod: {
            js: function () {
                // {i-route}
                this._iRoute = BEM.blocks['i-route'].getInstance();

                this._addListeners();
            }
        },

        _addListeners: function () {
            this._iRoute.on('render', this._onContentLoad, this);
        },

        /**
         * Checks if we need to hide or show this block
         **/
        _onContentLoad: function () {
            var isEmpty = false;
            var words = this._iRoute.get('words');
            if (words !== undefined) {
                isEmpty = !words.length;
            }
            this._toggle(!isEmpty);
        },

        /**
         * Sets hidden mod, if hidden=yes block will be hidden on the page
         *
         * @param {boolean} shown
         **/
        _toggle: function (shown) {
            if (shown) {
                this.setMod('hidden', '');
            } else {
                this.setMod('hidden', 'yes');
            }
        }
    });
})();
