(function () {
    'use strict';
    BEM.DOM.decl('b-history', {
        onSetMod: {
            js: function () {
                this._initBlock();
                if (this._periodRadio) {
                    this._refresh();
                    this._addListeners();
                    this._loaded[this._periodRadio.val()] = true;
                }
            }
        },

        destruct: function () {
            this._iRoute.un('refresh', this._refresh, this);
            this._iRoute.un('render', this._onRender, this);
            if (this._periodRadio) {
                this._periodRadio.un('change', this._onPeriodChange, this);
            }

            this.__base.apply(this, arguments);
        },

        _initBlock: function () {
            this._loaded = {weekly: false, monthly: false};
            // {i-route}
            this._iRoute = BEM.blocks['i-route'].getInstance();
            // {b-form-radio}
            this._periodRadio = this.findBlockOn('period-type-radio', 'b-form-radio');
            // {array:b-chart}
            this._charts = this.findBlocksInside('chart', 'b-chart');
        },

        /**
         * Get value from iRoute,
         * set default values if needed,
         * set values to DOM elements,
         * shows content for set params
         **/
        _refresh: function () {
            this._show(this._refreshDOM().period);
        },

        _refreshDOM: function () {
            var params = this._iRoute.get();
            if (this._periodRadio) {
                this._periodRadio.val(params.period);
            }
            return params;
        },

        _addListeners: function () {
            this._periodRadio.on('change', this._onPeriodChange, this);
            this._iRoute.on('refresh', this._refresh, this);
            this._iRoute.on('render', this._onRender, this);
        },

        _onPeriodChange: function () {
            var val = this._periodRadio.val(),
                $container = this.elem('data', 'group-by', val);

            if (!this._loaded[val]) {
                this._iRoute.load({period: val}, {
                    $container: $container,
                    selector: this.buildSelector('data', 'group-by', val)
                });
                this._loaded[val] = true;
                this._show(val);
            } else {
                this._iRoute.set({period: val});
                BEM.channel('window').trigger('resize');
                this._show(val);
            }
        },

        _onRender: function () {
            this._charts = this.findBlocksInside('chart', 'b-chart');
        },

        /**
         * @param {string} type
         **/
        _show: function (type) {
            if (type === 'weekly') {
                this.elem('data', 'group-by', 'monthly').hide();
                this.elem('data', 'group-by', 'weekly').show();
            } else {
                this.elem('data', 'group-by', 'weekly').hide();
                this.elem('data', 'group-by', 'monthly').show();
            }

            function invalidateSize(bChart) {
                bChart.invalidateSize();
            }
            this._charts.forEach(invalidateSize);
        }
    });
})();
