(function () {
    'use strict';
    BEM.DOM.decl('b-phrase-link', {
        onSetMod: {
            js: function() {
                this._initBlock();
                this._addListeners();
            }
        },

        _initBlock: function () {
            this._iRoute = BEM.blocks['i-route'].getInstance();
        },

        _addListeners: function () {
            this.bindTo('link', 'click', this._onClick);
        },

        _onClick: function (e) {
            if (e.button !== 0 || e.ctrlKey || e.metaKey || e.shiftKey || e.altKey) {
                return;
            }

            e.preventDefault();

            var params = {words: e.target.innerHTML};
            this._iRoute.set(params);
            this._iRoute.load(params);
        }
    });
})();
