(function () {
    'use strict';
    BEM.DOM.decl('b-region-select', {
        onSetMod: {
            js: function () {
                this._initBlock();
                this._addListeners();
            }
        },

        destruct: function () {
            if (this._bPopup) {
                this._bPopup.destruct();
            }
            this._bLink.un('click', this._onLinkClick, this);
            this.__base.apply(this, arguments);
        },

        show: function () {
            this.domElem.show();
        },

        hide: function () {
            this.domElem.hide();
        },

        /**
         * @param {string|undefined} ids - '1, 2, 3, 4'
         * @param {boolean} noChange - do not trigger change
         **/
        val: function (ids, noChange) {
            if (ids !== undefined) {
                if (this._setIds(ids, noChange)) {
                    this._refreshNames(ids);
                }
            } else {
                return this._regionsIds || '';
            }
        },

        /**
         * @return {string} - 'name1, name2, name3'
         **/
        getNames: function () {
            return this._regionsNames;
        },

        _initBlock: function () {
            // {b-popup}
            this._bPopup = this.findBlockOn('popup', 'b-popupa');
            // {b-link}
            this._bLink = this.findBlockInside('link', 'b-link');
            // {string}
            this._frameSrc = null;
            // {jQuery}
            this._iframeLayout = this.elem('iframe-layout');
            // {node}
            this._iframe = this.elem('iframe')[0];
            // {string} - '1, 2, 3, 4'
            this._regionsIds = '';
            // {string} - 'name1, name2, name3'
            this._regionsNames = '';
            // {jQuery}
            this._$link = this._bLink.elem('inner');

            // it is needed for regions popup
            // we load it's content from Direct and
            // this content made to be shown in new window
            // and we show it in iframe in popup
            var _this = this;
            window.setRegions = function () {
                _this._setRegions.apply(_this, arguments);
            };
        },

        _addListeners: function () {
            this._bLink.on('click', this._onLinkClick, this);
        },

        _onLinkClick: function () {
            if (this._frameSrc === null) {
                this._loadIFrame();
            }

            var _this = this;
            this.afterCurrentEvent(function () {
                _this._bPopup.show(_this._$link);
            });
        },

        _loadIFrame: function (ids) {
            var src = this._getIFrameSrc(ids);

            if (this._frameSrc !== src) {
                this._iframe.src = this._frameSrc = src;
            }
        },

        /**
         * On iframe submit
         *
         * @param {string} regionsIds - '1, 2, 3, 4'
         * @param {string} regionsNames - 'name1, name2, name3'
         **/
        _setRegions: function (regionsIds, regionsNames) {
            this._setIds(regionsIds);
            if (this._regionsIds === '') {
                regionsNames = '';
            }
            this._regionsNames = regionsNames;

            this._refreshLink(regionsNames);
            this._bPopup.hide();
        },

        /**
         * @param {string} ids
         * @param {boolean|undefined} noChange
         * @param {boolean} - if ids was changed
         **/
        _setIds: function (ids, noChange) {
            if (ids === null || ids === undefined || ids === '0') {
                ids = '';
            } else {
                ids = ids.replace(/,$/, '');
            }
            if (this._regionsIds !== ids) {
                this._regionsIds = ids;
                if (noChange !== true) {
                    this.trigger('change');
                }
                return true;
            }
            return false;
        },

        /**
         * @param {string}
         **/
        _refreshLink: function (regionsNames) {
            if (regionsNames === undefined || regionsNames === '') {
                regionsNames = BEM.I18N('b-region-select', 'All regions');
            }
            this._$link.html(regionsNames).attr('title', regionsNames);
        },

        _getIFrameSrc: function (ids) {
            var link = '/stat/regions_tree';
            if (ids === undefined) {
                ids = this._regionsIds;
            }
            if (ids !== null && ids !== undefined && ids !== '') {
                link += '?geo=' + ids;
            }
            return link;
        },

        /**
         * Load iframe
         **/
        _refreshNames: function (ids) {
            this._loadIFrame(ids);

            $(this._iframe).one('load', this._onIFrameLoad.bind(this));
        },

        /**
         * Make iframe submit data
         **/
        _onIFrameLoad: function () {
            var form = $(this._iframe.contentDocument).find('form');
            form.trigger('click');
            form.find('input[type="button"]').trigger('click');
        }

    });
})();
