/*globals AmCharts*/
(function () {
    'use strict';
    BEM.DOM.decl('b-regions-statistic', {
        onSetMod: {
            js: function () {
                this._initBlock();
                this._drawMap();
                this._refresh();
                this._addListeners();
            }
        },

        onElemSetMod: {
            'sort-link': {
                sorted: {
                    desc: function () {
                        this.delMod(this.elem('sort-link', 'sorted', 'desc'), 'sorted');
                    }
                }
            }
        },

        destruct: function () {
            if (this._bMap) {
                this._bMap.destruct();
            }
            if (this._$map) {
                this._$map.remove();
            }

            this._typeRadio.un('change', this._onTypeChange, this);
            this._filterRadio.un('change', this._onFilterChange, this);
            this._iRoute.un('refresh', this._refresh, this);
            //this._iRoute.remove(['filter', 'sort', 'type']);

            this._iRoute = null;
            this._typeRadio = null;
            this._filterRadio = null;
            this._$list = null;
            this._$map = null;

            this.__base.apply(this, arguments);
        },

        _initBlock: function () {
            // {i-route}
            this._iRoute = BEM.blocks['i-route'].getInstance();
            // {b-form-radio}
            this._typeRadio = this.findBlockOn('view-type-radio', 'b-form-radio');
            // {b-form-radio}
            this._filterRadio = this.findBlockOn('filter', 'b-form-radio');
            // {jQuery}
            this._$list = this.elem('list');
            // {jQuery}
            this._$map = null;

        },

        /**
         * Get value from _iRoute,
         * set default values if needed,
         * set values to DOM elements,
         * shows content for set params
         **/
        _refresh: function () {
            this._show(this._refreshDOM().type);
        },

        _refreshDOM: function () {
            var params = this._iRoute.get();
            this._setType(params.type);
            this._setFilter(params.filter);
            this._setSort(params.sort);
            return params;
        },

        /**
         * @param {string} val
         **/
        _setType: function (val) {
            this._typeRadio.val(val);
        },

        /**
         * @param {string} val
         **/
        _setFilter: function (val) {
            this._filterRadio.val(val);
        },

        /**
         * @param {jQuery|string} $link
         **/
        _setSort: function ($link) {
            if (typeof $link === 'string') {
                $link = this.findElem('sort-link', 'field', $link);
            }

            this.setMod($link, 'sorted', 'desc');
        },

        _drawMap: function () {
            this._$map = $(BEMHTML.apply({
                block: 'b-regions-statistic',
                elem: 'map-layout',
                content: {
                    block: 'b-map',
                    mix: [{block: 'b-regions-statistic', elem: 'map'}],
                    js: {
                        name: 'map',
                        data: this._getMapData(),
                        thousands_sep: this.params.thousands_sep
                    }
                }
            }));

            BEM.DOM.after(this.domElem.parents('body > *'), this._$map);
            this._bMap = this.findBlockInside(this._$map, 'b-map');
        },

        _getMapData: function () {
            return $.merge($.merge([], this.params.regions), this.params.cities).filter(function (v) {
                return v.am !== undefined;
            });
        },

        _addListeners: function () {
            this._typeRadio.on('change', this._onTypeChange, this);
            this._filterRadio.on('change', this._onFilterChange, this);
            this.bindTo('sort-link', 'click', this._onSortLinkClick);

            this._iRoute.on('refresh', this._refresh, this);
        },

        _onSortLinkClick: function (e) {
            var $sortLink = $(e.delegateTarget),
                $title = $(e.target),
                title = this.buildSelector('sort-title').slice(1);

            // if the click was not on title
            if (!$title.hasClass(title)) {
                return;
            }

            this._iRoute.set('sort', this._getSortBy($sortLink));
            this.setMod($sortLink, 'sorted', 'desc');
            this._show();
        },

        _onFilterChange: function () {
            var val = this._filterRadio.val();
            this._iRoute.set('filter', val);
            this._show();
        },

        _onTypeChange: function () {
            var val = this._typeRadio.val();
            this._iRoute.set('type', val);
            this._show(val);
        },

        /**
         * @param {jQuery} $link
         **/
        _getSortBy: function ($link) {
            if ($link === undefined || $link.length === 0) {
                $link = this.findElem('sort-link', 'sorted', 'desc');
            }
            if ($link && $link.length) {
                return this.getMod($link, 'field');
            }
        },

        _show: function (type) {
            if (type === undefined) {
                type = this._typeRadio.val();
            }
            var $map = this.findElem(this._$map, 'map');
            if (type === 'list') {
                this._$list.show();
                // so that map would not shiver on page resize
                $map.css({position: 'absolute', left: -2000, top: -2000});
                this._refreshTable();
            } else if (type === 'map') {
                $map.css({position: 'static', left: 'auto', top: 'auto'});
                this._$list.hide();
                this._bMap.refresh();
            }
        },

        _refreshTable: function () {
            var _this = this,
                data = this._genData();

            function genTr(value, index) {
                return {
                    tag: 'tr',
                    block: 'b-regions-statistic',
                    elem: 'tr',
                    elemMods: (index % 2 === 0 ? {type: 'even'} : null),
                    content: [
                        {
                            tag: 'td',
                            elem: 'td',
                            elemMods: {type: value.type},
                            content: value.name
                        },
                        {
                            tag: 'td',
                            elem: 'td',
                            elemMods: {type: 'number'},
                            content: AmCharts.formatNumber(value.cnt, {
                                precision: -1,
                                decimalSeparator: '.',
                                thousandsSeparator: _this.params.thousands_sep
                            })
                        },
                        {
                            tag: 'td',
                            elem: 'td',
                            elemMods: {type: 'number'},
                            content: AmCharts.formatNumber(value.pp, {
                                precision: -1,
                                decimalSeparator: '.',
                                thousandsSeparator: _this.params.thousands_sep
                            }) + '%'
                        }
                    ]
                };
            }

            BEM.DOM.update(this.findElem('data'), BEMHTML.apply(data.map(genTr)));
        },

        _genData: function () {
            var _this = this,
                filter = this._filterRadio.val(),
                data = [];

            filter = filter === 'all' ? ['regions', 'cities'] : [filter];

            $.each(filter, function (index, fvalue) {
                $.merge(
                    data,
                    $.map(_this.params[fvalue], function (value) {
                        return $.extend({}, value, {type: fvalue});
                    })
                );
            });

            // sort
            var sortBy = this._getSortBy();
            data.sort(function (a,b) {return b[sortBy] - a[sortBy];});

            return data;
        }
    });
})();
