(function () {
    'use strict';
    BEM.DOM.decl('b-search', {

        onSetMod: {
            js: function () {
                this._initBlock();
                this._addListeners();
                this._refreshDOM();

                this.afterCurrentEvent(function () {
                    // нужно, чтобы load произошел после инициализации блока b-domik_type_popup
                    // потому что зависимость i блока от b не хочет работать
                    var values = this._iRoute.get();
                    if (!this._iRoute.hasParams() && this.params.defaults) {
                        // устанавливать дефолтные значения имеет смысл, только если другие значения не были установлены
                        this._iRoute.set(this.params.defaults);
                    } else if (values.page_type === 'words' && values.words || values.page_type !== 'words') {
                        // загружать имеет смысл либо, если мы не на странице words (которая дефолтная)
                        // либо, если были установлены слова
                        this._iRoute.load();
                    }
                }, this);
            }
        },

        _initBlock: function () {
            // {i-route}
            this._iRoute = BEM.blocks['i-route'].getInstance();
            // {b-form-input}
            this._wordsInput = this.findBlockInside('search', 'b-form-input');
            // {b-region-select}
            this._bRegionSelect = this.findBlockOn('region-select', 'b-region-select');
            // {jQuery}
            this._typeRadio = this.elem('type');

            this._iRoute.on('error', this._onError, this);
        },

        _refreshDOM: function () {
            var params = this._iRoute.get();
            // page_type
            this._setPageType(params.page_type);
            // words
            this._setWords(params.words);
            // region
            if (this._showRegions(params.page_type)) {
                this._bRegionSelect.val(params.regions, true);
            }
        },

        /**
         * @param {string} val
         **/
        _setPageType: function (val) {
            this._typeRadio.filter('[value="' + val + '"]').prop('checked', true);
        },

        /**
         * @return {string}
         **/
        _getPageType: function () {
            return this._typeRadio.filter(':checked').val();
        },

        /**
         * @param {string} val
         **/
        _setWords: function (val) {
            this._wordsInput.val(val);
        },

        /**
         * @param {string} pageType
         * @return {boolean}
         **/
        _showRegions: function (pageType) {
            var show = false;
            if (this._hasRegions(pageType) === true) {
                this._bRegionSelect.show();
                show = true;
            } else {
                this._bRegionSelect.hide();
                show = false;
            }
            return show;
        },

        /**
         * @param {string} pageType
         * @return {boolean}
         **/
        _hasRegions: function (pageType) {
            var $el = this._typeRadio.filter('[value="' + pageType + '"]');
            return this.hasMod($el, 'with-regions', 'yes');
        },

        _addListeners: function () {
            this.domElem.on('submit', this._onSubmit.bind(this));
            this.bindTo('type', 'change', this._onChange);
            this._iRoute.on('refresh', this._refreshDOM, this);
            this._iRoute.on('set', this._refreshDOM, this);
            this._iRoute.on('load', this._onLoad, this);
            this._bRegionSelect.on('change', this._onChange, this);
        },

        _onSubmit: function (e) {
            e.preventDefault();
            this._iRoute.load(this._getParamsFromDOM());
        },

        _onChange: function () {
            this._iRoute.removePrivat();
            this._iRoute.load(this._getParamsFromDOM());
        },

        _getParamsFromDOM: function () {
            var params = {};
            params.page_type = this._getPageType();
            if (this._showRegions(params.page_type)) {
                params.regions = this._bRegionSelect.val();
            } else {
                params.regions = '';
            }
            params.words = this._wordsInput.val();
            return params;
        },

        _onLoad: function () {
            this._wordsInput.setMod('focused', 'yes');
        },

        /**
         * @private
         * @param {event} e
         * @param {object} data
         */
        _onError: function (e, data) {
            this.toggleMod('error', 'yes', '', data.hasError);
        }
    });
})();
