/**
 * Toolpits with text in popup
 *
 * @author nafania
 **/
(function () {
    'use strict';
    BEM.DOM.decl('b-tooltip', {
        _data: null,

        onSetMod: {
            js: function() {
                this._init_block();
                this._get_popup();
                this._add_events();
            }
        },

        _init_block: function() {
            var data = this._data = {
                b_popup: null
            };
        },

        _get_popup: function() {
            this._data.b_popup = this.findBlockOn('popup', 'b-popupa');
        },

        _add_events: function() {
            this.bindTo('switcher', 'click', this._show_popup);
        },

        _show_popup: function(e) {
            this._data.b_popup.show($(e.target));
        }

    });
})();
