(function () {
    'use strict';
    BEM.DOM.decl('b-word-statistics', {
        onSetMod: {
            js: function () {
                this._initBlock();
                this._refreshCurrentPage();
                this._addListeners();
                this._onResize();
            }
        },

        destruct: function () {
            this._iRoute.un('refresh', this._refreshCurrentPage, this);
            if (this._$next !== null) {
                this._$next.off('click', this._onNextClick.bind(this));
            }
            if (this._$prev !== null) {
                this._$prev.off('click', this._onPrevClick.bind(this));
            }
            if (this._bPager !== null) {
                this._bPager.destruct();
            }
            BEM.channel('window').un('resize', this._onResize, this);
            this.__base.apply(this, arguments);
        },

        _initBlock: function () {
            // {i-route}
            this._iRoute = BEM.blocks['i-route'].getInstance();
            // {b-pager}
            this._bPager = this.findBlockInside('pager', 'b-pager');
            // {number}
            this._currentPage = 1;
            // {jQuery}
            this._$next = null;
            // {jQuery}
            this._$prev = null;

            if (this._bPager !== null) {
                var page = parseInt(this._bPager.elem('current').text(), 10);
                if (isNaN(page)) {
                    page = 1;
                }
                this._currentPage = page;
                this._$next = this._bPager.elem('next');
                this._$prev = this._bPager.elem('prev');
            }

            this._onPrevClick = this._onPrevClick.bind(this);
            this._onNextClick = this._onNextClick.bind(this);
        },

        _addListeners: function () {
            if (this._$next !== null && this._$next.is('a')) {
                this._$next.on('click', this._onNextClick.bind(this));
            }
            if (this._$prev !== null && this._$prev.is('a')) {
                this._$prev.on('click', this._onPrevClick.bind(this));
            }
            this._iRoute.on('refresh', this._refreshCurrentPage, this);
            BEM.channel('window').on('resize', this._onResize, this);
        },

        _refreshCurrentPage: function () {
            var page = parseInt(this._iRoute.get('page'), 10);
            if (isNaN(page)) {
                page = 1;
            }
            if (page !== this._currentPage) {
                this._currentPage = page;
            }
        },

        _onNextClick: function (e) {
            e.preventDefault();
            this._iRoute.load({page: this._currentPage + 1});
        },

        _onPrevClick: function (e) {
            e.preventDefault();
            this._iRoute.load({page: this._currentPage - 1});
        },

        _onResize: function () {
            var $info = this.elem('info');
            var $infoWrapper = this.elem('info-wrapper');
            var maxHeight = 0;

            $info.each(function (ind, el) {
                var height = $(el).height();
                maxHeight = height > maxHeight ? height : maxHeight;
            });

            $infoWrapper.height(maxHeight);
        }
    });
})();
