/**
 * Content block
 *
 * @author nafania
 **/
(function () {
    'use strict';

    BEM.DOM.decl('b-wordstat-content', {
        onSetMod: {
            js: function () {
                this._onResize = $.throttle(this._onResize, 100);
                this._addEvents();
            }
        },

        destruct: function () {
            $(window).off('resize', this._onResize);
        },

        _addEvents: function () {
            $(window).on('resize', this._onResize);
        },

        _onResize: function () {
            BEM.channel('window').trigger('resize');
        }
    });
})();
