(function () {
    'use strict';
    BEM.DOM.decl('i-global', {}, {
        refreshRetpath: function () {
            var url = document.location.href;
            if (_byteLength(encodeURIComponent(decodeURI(url))) > 1900) {
                url = _removeParam(document.location.href, 'words');
            }
            this._params.retpath = url;
        }
    });

    /**
     * @private
     * @param {string} url
     * @param {string} param
     * @return {string}
     */
    function _removeParam(url, param) {
        var parts = url.split('?');
        var baseUrl = parts[0];
        var search = parts[1];

        if (!search) {
            return url;
        }

        var searchParams = search.split('&');
        if (searchParams.length === 1) {
            return baseUrl.replace(/#!\/$/, '');
        }

        var newSearchParams = [];
        $.map(searchParams, function (searchParam) {
            if (searchParam.split('=')[0] !== param) {
                newSearchParams.push(searchParam);
            }
        });

        return [baseUrl, newSearchParams.join('&')].join('?');
    }

    /**
     * Считает длину строки в utf8
     * http://stackoverflow.com/questions/5515869/string-length-in-bytes-in-javascript
     * Пробовала вариант из обсуждения с регуляркой - тесты висли, хотя в браузере функция быстро отрабатывала
     *
     * @private
     * @param {string} str
     * @return {integer}
     */
    function _byteLength(str) {
        // returns the byte length of an utf8 string
        var s = str.length;
        for (var i = str.length - 1; i >= 0; i--) {
            var code = str.charCodeAt(i);
            if (code > 0x7f && code <= 0x7ff) {
                s++;
            } else if (code > 0x7ff && code <= 0xffff) {
                s += 2;
            }
            if (code >= 0xDC00 && code <= 0xDFFF) {
                i--; //trail surrogate
            }
        }
        return s;
    }
})();
