/**
 * Content layout,
 * content is the same width as arrow in l-head
 *
 * @author nafania
 **/
(function () {
    'use strict';
    BEM.DOM.decl('l-content', {
        _data: null,

        onSetMod: {
            js: function() {
                this._initBlock();
                this._addEvents();
                this._onResize();
            }
        },

        destruct: function () {
            BEM.channel('window').un('resize', this._onResize, this);
        },

        _initBlock: function() {
            this._data = {
                $bHeadSearch: $('.b-head-search')
            };

            // {i-route}
            this._iRoute = BEM.blocks['i-route'].getInstance();
            this._iRoute.triggerError(this.hasMod('error', 'yes'));
        },

        _addEvents: function() {
            BEM.channel('window').on('resize', this._onResize, this);
        },

        _onResize: function() {
            this.elem('content').css('width', this._data.$bHeadSearch.width());
        }

    });
})();
