#!/bin/bash -x

set -em

: ${USER:?"USER environment variable must be set"}
: ${EMAIL:?"EMAIL environment variable must be set"}
: ${DEBFULLNAME:?"DEBFULLNAME environment variable must be set"}
: ${DEBEMAIL:?"DEBEMAIL environment variable must be set"}

trap 'killall --exact --process-group sky-server.sh' SIGINT SIGTERM EXIT

SKYHOST_PORT=${SKYHOST_PORT:-7075}
./sky-server.sh $SKYHOST_PORT &
SKYHOST=${SKYHOST:-"$(hostname --fqdn):$SKYHOST_PORT"}
echo "$SKYHOST" > ./docker_env/_common/skyhost

docker build -t registry.yandex.net/wordstat/frontend__common ./docker_env/_common
docker build -t registry.yandex.net/wordstat/frontend_build ./docker_env/builder

docker run \
    -e USER \
    -e EMAIL \
    -e DEBFULLNAME \
    -e DEBEMAIL \
    -ti \
    -v $(readlink -f .):/app \
    registry.yandex.net/wordstat/frontend_build \
    bash -c 'debuild -i -us -uc -b --lintian-opts --suppress-tags dir-or-file-in-opt,maintainer-script-calls-init-script-directly,arch-dependent-file-in-usr-share && mv ../yandex-wordstat-frontend* ./'

cp yandex-wordstat-frontend*.deb docker_env/deploy/dist_local/files/
docker build -t registry.yandex.net/wordstat/frontend_deploy_build:"$(date +'%Y%m%d%H%M')" ./docker_env/deploy

echo "Build complete"
