#!/bin/bash

### BEGIN INIT INFO
# Provides:          wordstat-frontend
# Required-Start:    $local_fs $remote_fs $network $syslog
# Required-Stop:     $local_fs $remote_fs $network $syslog
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: starts wordstat's daemons
# Description:       starts wordstat's daemons using start-stop-daemon
### END INIT INFO

ulimit -n 8192
export "LD_PRELOAD=/usr/lib/libtcmalloc_minimal.so.4"

DIR=/var/run/wordstat

PATH=/bin:/usr/bin:/sbin:/usr/sbin

NGINX_DAEMON=/usr/sbin/nginx
NGINX_PIDFILE=/var/run/nginx.pid
NGINX_CONF=/etc/wordstat/nginx.conf

FCGI_DAEMON=/usr/bin/qbit_fcgi_starter
FCGI_ARGS="--workers=300 --backlog=100000 --max-requests=1400 --user=wordstat --lib-path=/usr/share/wordstat/lib --listen=$DIR/fcgi.sock"
FCGI_PIDFILE=$DIR/fcgi.pid

MEMCACHED_DAEMON=/usr/bin/memcached
MEMCACHED_ARGS="-m 2048 -t 8 -u wordstat -s $DIR/memcached.sock"
MEMCACHED_PIDFILE=$DIR/memcached.pid

trap "" 1
export PATH

case "$1" in
  start)
    $0 memcached_start
    $0 fcgi_start
    $0 nginx_start
    exit $?
    ;;

  stop)
    $0 nginx_stop
    $0 fcgi_stop
    $0 memcached_stop
    exit $?
    ;;

  restart|force-reload)
    $0 stop
    $0 start
    exit $?
    ;;


  nginx_start)
    echo "Starting nginx"
    mkdir -p /var/run/wordstat
    chown wordstat:wordstat /var/run/wordstat
    start-stop-daemon --start --pidfile $NGINX_PIDFILE --exec $NGINX_DAEMON -- -c $NGINX_CONF
    ;;

  nginx_stop)
    echo "Stopping nginx"
    start-stop-daemon --stop --pidfile $NGINX_PIDFILE --oknodo --exec $NGINX_DAEMON --retry 1
    ;;

  nginx_restart)
    $0 nginx_stop
    $0 nginx_start
    exit $?
    ;;


  fcgi_start)
    echo "Starting FastCGI"
    mkdir -p /var/run/wordstat
    chown wordstat:wordstat /var/run/wordstat

    mkdir -p /var/lib/wordstat
    cp /var/lib/tvmtool/local.auth /var/lib/wordstat/tvmtool.token.new
    chown wordstat:wordstat /var/lib/wordstat/tvmtool.token.new
    mv /var/lib/wordstat/tvmtool.token.new /var/lib/wordstat/tvmtool.token

    start-stop-daemon --start --pidfile $FCGI_PIDFILE --exec /usr/bin/perl -- $FCGI_DAEMON $FCGI_ARGS --daemonize --pid=$FCGI_PIDFILE Wordstat::WebInterface
    ;;

  fcgi_stop)
    echo "Stopping FastCGI"
    start-stop-daemon --stop --pidfile $FCGI_PIDFILE --oknodo --retry 65
    ;;

  fcgi_restart)
    $0 fcgi_stop
    $0 fcgi_start
    exit $?
    ;;


  memcached_start)
    echo "Starting memcached"
    mkdir -p /var/run/wordstat
    chown wordstat:wordstat /var/run/wordstat
    start-stop-daemon --start --pidfile $MEMCACHED_PIDFILE --exec $MEMCACHED_DAEMON -- $MEMCACHED_ARGS -d -P $MEMCACHED_PIDFILE
    ;;

  memcached_stop)
    echo "Stopping memcached"
    start-stop-daemon --stop --pidfile $MEMCACHED_PIDFILE --oknodo --exec $MEMCACHED_DAEMON --retry 1
    ;;

  memcached_restart)
    $0 memcached_stop
    $0 memcached_start
    exit $?
    ;;

  *)
    echo "Usage: /etc/init.d/$NAME {start|stop|restart|nginx_start|nginx_stop|nginx_restart|fcgi_start|fcgi_stop|fcgi_restart|memcached_start|memcached_stop|memcached_restart}"
    exit 1
    ;;
esac

if [ $? == 0 ]; then
  echo OK
  exit 0
else
  echo Failed
  exit 1
fi
