#!/bin/bash

APP_ENV=$1

mkdir -p /var/run/wordstat
/usr/local/bin/mk_internal_nets.sh

mkdir -p /var/lib/wordstat/
echo $TVMTOOL_LOCAL_AUTHTOKEN > /var/lib/wordstat/tvmtool.token
chown -R wordstat /var/lib/wordstat/

ls /usr/share/wordstat/lib/Application.cfg || ln -s /usr/share/wordstat-configs/configs/Application."$APP_ENV".cfg /usr/share/wordstat/lib/Application.cfg
ls /usr/share/wordstat/lib/WebInterface.cfg || ln -s /usr/share/wordstat-configs/configs/WebInterface."$APP_ENV".cfg /usr/share/wordstat/lib/WebInterface.cfg

chown wordstat /var/run/wordstat/
chown wordstat /etc/wordstat

WORKERS_COUNT=300
if [[ ${APP_ENV} == 'testing' ]]; then
    WORKERS_COUNT=10
fi

sudo -E -u wordstat /usr/bin/perl -- /usr/bin/qbit_fcgi_starter --workers="${WORKERS_COUNT}" --backlog=100000 --max-requests=1400 --user=wordstat --lib-path=/usr/share/wordstat/lib --listen=/var/run/wordstat/fcgi.sock --pid=/var/run/wordstat/fcgi.pid Wordstat::WebInterface
