#!/bin/bash

set -e

# test -z "${EMAIL}" && echo "add '-e EMAIL'" && false
test -z "${USER}" && echo "add '-e USER'" && false
test -z "${PORT}" && echo "set \$PORT and add '-e PORT'" && false
test ! -s "/root/.ssh/id_rsa" && echo "add '-v /home/\$HOME/.ssh:/root/.ssh:ro'" && false

cd beta${PORT}

yav-deploy -c ./etc/yandex/yav-deploy --oauth ${YAV_TOKEN} --debug

# create tvmtool.token and start tvm service
export TVMTOOL_LOCAL_AUTHTOKEN='tvmtool-development-access-token'
tvmtool -c ./etc/tvmtool/tvmtool.conf -a ${TVMTOOL_LOCAL_AUTHTOKEN} &

# store tvmtool.token
mkdir -p /var/lib/wordstat/
echo ${TVMTOOL_LOCAL_AUTHTOKEN} > /var/lib/wordstat/tvmtool.token
chown -R wordstat /var/lib/wordstat/

make beta_create

# patch for root
sed -i 's/MEMCACHED_ARGS="/MEMCACHED_ARGS="-u root /' ./nginx/init.sh
# pathc for docker host
sed -i 's/dev-partner/'$(hostname -f)'/' ./lib/Application.cfg

./nginx/init.sh restart

/bin/bash
