package QBit::Application::Model::DB::mysql::Table::EventLog;
{
  $QBit::Application::Model::DB::mysql::Table::EventLog::VERSION = '0.002';
}

use qbit;

use base qw(QBit::Application::Model::DB::mysql::Table);

sub default_fields {
    my ($package, %opts) = @_;

    return (
        {name => 'id', type => 'BIGINT',   not_null => TRUE, unsigned => TRUE, autoincrement => TRUE},
        {name => 'dt', type => 'DATETIME', not_null => TRUE},
        (map {{name => "elem_$_", not_null => TRUE}} @{$opts{'pk'}}),
        {name => 'name',  type => 'VARCHAR', not_null => TRUE, length => 512,},
        {name => 'color', type => 'TINYINT', not_null => TRUE, length => '6',},
        ($opts{'with_desc'} ? {name => 'desc', type => 'TEXT', not_null => TRUE} : ()),
    );
}

sub default_primary_key {
    return ['id'];
}

sub default_indexes {
    my ($package, %opts) = @_;
    my @elems = $opts{'pk'} ? map("elem_$_", @{$opts{'pk'}}) : 'elem_id';
    return ({fields => ['dt', @elems]}, {fields => [@elems]});
}

sub default_foreign_keys {
    my ($package, %opts) = @_;
    return ([[map {"elem_$_"} @{$opts{'pk'}}] => $opts{'table'} => $opts{'pk'}],);
}

TRUE;
