package QBit::Gettext::Extract::Lang::JS;

use qbit;

use base qw(QBit::Gettext::Extract::Lang);

sub extract_from_file {
    my ($self, $filename, $po) = @_;

    $filename =~ m#(.*)/[^/]+\.i18n_list$#;

    my $keyset = $1;

    my $text = readfile($filename);

    my $keys;
    try {
        $keys = from_json($text);
    }
    catch {
        throw "Incorrect data in '$filename': " . shift->message;
    };

    my $line = 0;
    foreach (@$keys) {
        $line++;
        $po->add_message(
            filename => 'LEGO/' . $keyset,
            line     => $line,
            message  => $_
        );
    }
}

TRUE;
