package QBit::WebInterface::Controller::BEMHTML::Form;

use qbit;

use base qw(QBit::WebInterface::Controller::Form);

sub init {
    my ($self) = @_;

    local $QBit::WebInterface::Controller::Form::FIELDS_NAMESPACE =
      'QBit::WebInterface::Controller::BEMHTML::Form::Field::';
    $self->SUPER::init();
}

sub start_form_html {
    my ($self) = @_;

    my $html;

    if (defined $self->{'title'}) {
        $html .= "{block: 'b-form-title',content: '"
          . QBit::WebInterface::Controller::BEMHTML::_bem_encode(html_encode($self->{'title'})) . "'},";
    }

    if (defined $self->{'description'}) {
        $html .= "{block: 'b-form-description',content: '"
          . QBit::WebInterface::Controller::BEMHTML::_bem_encode(html_encode($self->{'description'})) . "'},";
    }

    my $stash_name      = $self->get_stash_form_name('complete_message');
    my $success_message = $self->{controller}->stash_delete($stash_name);
    if (defined $success_message) {
        $html .= "{block: 'b-form-complete',content: '"
          . QBit::WebInterface::Controller::BEMHTML::_bem_encode(html_encode($success_message)) . "'},";
    }

    $html .= "{\nblock: 'b-form',\nmods: {errorable: 'yes'},\nattrs: {method: 'POST'";

    map {
            $html .= ",\n"
          . QBit::WebInterface::Controller::BEMHTML::_bem_encode($_) . ": '"
          . QBit::WebInterface::Controller::BEMHTML::_bem_encode($self->{'attrs'}{$_}) . "'";
      } grep {
        $_ !~ m/method/i
      } keys(%{$self->{'attrs'}}) if $self->{'attrs'};

    $html .= ",\nenctype: '$self->{enctype}'" if $self->{'enctype'};

    $html .= "},\ncontent: [\n";

    $html .= $_->as_html() foreach grep {$_->is_hidden()} @{$self->{'__FIELDS__'}};

    my @hidden_block_fields = grep {$_->{'hidden'}} @{$self->{'__FIELDS__'}};
    if (@hidden_block_fields) {
        $html .= '{attrs: {style: \'display: none;\'}, content: [';
        $html .= $_->as_html() foreach @hidden_block_fields;
        $html .= ']},';
    }

    $html .=
        '{ block: \'b-form-error\', content: { elem: \'error\', content: \''
      . QBit::WebInterface::Controller::BEMHTML::_bem_encode(html_encode($self->{'__ERROR__'}->message())) . '\'}}'
      . ",\n"
      if exists($self->{'__ERROR__'});

    return $html;
}

sub finish_form_html {
    my ($self) = @_;

    return "]\n},\n";
}

sub as_html {
    my ($self) = @_;

    my $html = $self->start_form_html();
    $html .= '{elem: \'row\', content: [' . $_->as_html() . ']},'
      foreach grep {!$_->is_hidden() && !$_->{'hidden'}} @{$self->{'__FIELDS__'}};
    $html .= $self->finish_form_html();

    return $html;
}

sub _get_html {
    my ($self, $controller) = @_;

    my $is_ajax = $controller->request->param('ajax');

    return $controller->as_json(
        {
            error => (defined($self->{'__ERROR__'}) ? $self->{'__ERROR__'}->message() : undef),
            field_errors =>
              {map {$_ => $self->{'__FIELDS_ERROR__'}->{$_}->message()} keys(%{$self->{'__FIELDS_ERROR__'}})}
        }
      )
      if $is_ajax
          && $controller->request->param('save')
          && (keys(%{$self->{'__FIELDS_ERROR__'}}) || $self->{'__ERROR__'});

    return $controller->from_bem_template(
        $self->{'template'} || 'common/form.bem.tt2',
        vars => {%{$self->{'vars'} || {}}, form => $self, disable_page_wrapper => $is_ajax},
        show_bem_json => $is_ajax
    );
}

sub _on_complete {
    my ($self, $controller) = @_;

    $self->{'redirect_opts'} ||= {};

    my $retpath = $self->controller->request->param('retpath');

    if ($self->controller->request->param('ajax')) {
        my %json;

        $json{'action'} = 'redirect' if $retpath || exists($self->{'redirect'});
        $json{'action'} ||= $self->{'ajax_action'} // 'close';

        $json{'url'} = $self->controller->_get_url_absolute($retpath) if $retpath;
        $json{'url'} ||= $self->controller->app->make_cmd(
            $self->{'redirect'},
            delete($self->{'redirect_opts'}{'path'}),
            %{$self->{'redirect_opts'}}
        ) if exists($self->{'redirect'});

        $json{'data'} = $self->{'ajax_action_data'} if exists($self->{'ajax_action_data'});

        $self->controller->as_json(\%json);
    } else {
        return $self->SUPER::_on_complete($controller);
    }
}

1;
