(function (BEM) {
    'use strict';

    BEM.DOM.decl('b-form-multilang-input', {
        onSetMod: {
            js: function () {
                this.langs = this
                    .findBlockOn('popup', 'b-popupa')
                    .on('outside-click', this.onOutsideClick, this);

                var parentPopup = this.findBlockOutside('b-popupa');
                if (parentPopup) {
                    parentPopup.on('hide', this.hideLangs, this);
                }

                this.input = this
                    .findBlockInside(this.elem('input'), 'b-form-input')
                    .on('focus', this.showLangs, this);

                this.findBlockInside('save', 'b-form-button')
                    .on('click', this.save, this);

                this.findBlockInside('cancel', 'b-form-button')
                    .on('click', this.cancel, this);

                this.langsShown = false;
            }
        },

        destruct: function () {
            this.langs.destruct();
            this.__base.apply(this, arguments);
        },

        showLangs: function () {
            if (!this.langsShown) {
                this.elem('wrapper').width(this.elem('input').width());
                this.langs.show(this.domElem);
                this.langsShown = true;
            }
        },

        hideLangs: function () {
            this.langs.hide();
            this.langsShown = false;
        },

        /* Сбрасываем значения инпутов
         * на значения спрятанных полей */
        cancel: function () {
            var _this = this;
            var fields = this.getLangFields();

            this.elem('hidden').each(function () {
                var _$this = $(this);
                var key = _this.getMod(_$this, 'key');

                fields[key].val(_$this.val());
            });

            this.hideLangs();
        },

        /* Обновляем значения спрятанных полей
         * значениями инпутов */
        save: function () {
            var _this = this;
            var fields = this.getLangFields();
            var currentLang = this.params.currentLang;

            this.elem('hidden').each(function () {
                var _$this = $(this);
                var key = _this.getMod(_$this, 'key');

                _$this.val(fields[key].val());

                currentLang === key &&
                    _this.input.val(fields[key].val());
            });

            this.hideLangs();
        },

        getLangFields: function () {
            var fields = {};

            this.langs
                .findBlocksInside('b-form-input')
                .forEach(function (block) {
                    var key = block.getMod('key');

                    fields[key] = block;
                });

            return fields;
        },

        onOutsideClick: function (e) {
            e.preventDefault();
        }
    });
})(BEM);
