/*global alert, BEMHTML*/
(function ($) {
    'use strict';

    /**
     * Ищет блок b-form-button с типом кнопки submit в указанном элементе
     * @param  {DOMElement} root корневой DOM-элемент
     * @return {Block}           блок b-form-button
     */
    function getSubmitButtonBlock(root) {
        var blockDomElement = $('input[type=submit]', root).closest('.b-form-button');
        if (blockDomElement.length > 0) {
            return blockDomElement.bem('b-form-button');
        }

        return null;
    }

    BEM.DOM.decl('b-wizard-form', {

        onSetMod: {
            js: function() {
                this.replaceSubmit();
                this.loadingPopup = this.findBlockOn('loading-popup', 'b-popupa');
                this.spin = this.findBlockOn('mask-spin', 'b-spin');
            },
            loading: {
                yes: function () {
                    if (this.submit) {
                        this.submit.setMod('disabled', 'yes');
                    }

                    this.spin.setMod('progress', 'on');
                    this.loadingPopup.show(this.domElem);
                },
                '': function () {
                    if (this.submit) {
                        this.submit.delMod('disabled');
                    }
                    this.spin.delMod('progress');
                    this.loadingPopup.hide();
                }
            }

        },

        replaceSubmit: function() {
            var formBlock = this.bForm = this.findBlockInside('b-form');
            this.submit = getSubmitButtonBlock(this.domElem);
            formBlock.bindTo('submit', $.proxy(this._onSubmitClick, this));
        },

        _onSubmitClick: function () {
            if (this.bForm.hasMod('valid', 'yes')) {
                this.trigger('submit');
                this.setMod('loading', 'yes');
                $.ajax({
                    type: 'POST',
                    url: this.params.url,
                    dataType: 'json',
                    data: this.bForm.domElem.serialize() + '&ajax=1',
                    success: $.proxy(this._onSubmitSuccess, this),
                    error: $.proxy(this._onSubmitError, this)
                });
            }
            return false;
        },

        _onSubmitSuccess: function (obj) {
            var content = this.elem('content');

            this.delMod('loading');
            this.trigger('loaded');
            if (typeof(obj) == 'object' && obj.error) {
                alert(obj.error);
                return;
            }

            if (obj.action == 'redirect') {
                this.trigger('action', {name: 'redirect', url: obj.url});
                this.setMod('loading', 'yes');
                document.location = obj.url;
                return;
            }

            this.bForm.trigger('redraw');

            var tabs = this.findBlocksInside('b-wizard-form-tab');
            for (var i = 0; i < tabs.length; i++) {
                tabs[i].setMod('status', i == obj.stage ? 'active' : i < obj.stage ? 'completed' : 'disabled');
                BEM.DOM.update(tabs[i].elem('id'), i < obj.stage ? '' : i + 1);
            }

            BEM.DOM.update(content, BEMHTML.apply(obj.content));
            this.replaceSubmit();
        },

        _onSubmitError: function (data) {
            this.delMod('loading');
            this.trigger('loaded');
            alert(data.responseText);
        }

    });

})(jQuery);
