/*global require, Vow, BEM, jQuery*/
(function (BEM, Vow, $) {

    'use strict';

    function ajax() {
        var result = Vow.promise();

        $.ajax.apply($, arguments)
            .done(function (data) {
                result.fulfill(data);
            })
            .fail(function (jqXHR) {
                result.reject(jqXHR);
            });

        return result;
    }

    ajax.get = function (url, data, dataType) {
        return ajax({
            url: url,
            data: data,
            dataType: dataType
        });
    };

    ajax.post = function (url, data, dataType) {
        return ajax({
            type: 'POST',
            url: url,
            data: data,
            dataType: dataType
        });
    };

    ajax.getJSON = function (url, data) {
        return ajax.get(url, data, 'json');
    };

    ajax.postJSON = function (url, data) {
        return ajax.post(url, data, 'json');
    };

    BEM.DOM.decl({block: 'i-promises', elem: 'ajax'}, {}, {
        ajax: ajax
    });

})(BEM, (typeof require != 'undefined' && require('vow')) || Vow, jQuery);
