package Wordstat::WebInterface;

use qbit;

use base qw(Wordstat::Application QBit::WebInterface::FastCGI);

use QBit::Application::Model::YandexLangDetect accessor        => 'lang_detect';
use QBit::Application::Model::Yandex::Geobase accessor         => 'geobase';
use QBit::Application::Model::API::Yandex::Captcha accessor    => 'captcha';
use QBit::Application::Model::Yandex::FlashCookie accessor     => 'flash_cookie';
use QBit::Application::Model::API::Yandex::BlackBox   accessor => 'api_blackbox';
use QBit::Application::Model::API::Yandex::BotBlocker accessor => 'api_bot_blocker';

use Yandex::Utils;
use Yandex::SecretKey;

use POSIX qw(localeconv setlocale);

__PACKAGE__->use_config('WebInterface.cfg');

use Wordstat::WebInterface::Controller::Statistics path    => 'stat';
use Wordstat::WebInterface::Controller::MagicalCookie path => 'dir_advq';
use Wordstat::WebInterface::Controller::Check path         => 'check';

sub default_cmd {stat => 'page'}

sub pre_cmd {
    my ($self, $controller) = @_;

    my $headers = $self->response->headers;
    push_hs($headers, {'Cache-Control' => 'no-cache, no-store, max-age=0, must-revalidate', Pragma => 'no-cache'});

    # MDA disabled in https://st.yandex-team.ru/ADVQ-1534
    my $no_mda = 1;
    if ($no_mda) {
        $self->set_option(no_mda => 1);
    }

    $self->timelog->start(gettext('Auth user'));
    $self->set_option(cur_user => $self->_get_bb_cur_user($controller, no_mda => $no_mda));
    $self->timelog->finish();

    $self->request->cookie('my');

    $self->timelog->start('Getting regions by ip');
    my $regions = $self->geobase->get_region_parents_by_ip($self->request->remote_addr());

    if ($self->get_option('region_debug', '') && $self->request->param('_region', '')) {
        # tur 103744
        # ua 20539
        # crym 27161
        $regions = $self->geobase->_get_lookup()->parents($self->request->param('_region', ''));
    }



    $self->timelog->finish();

    my $user_lang = $self->lang_detect->get_user_lang(
        regions         => $regions,
        supported       => [keys(%{$self->get_option('locales')})],
        accept_language => $self->request->http_header('Accept-Language'),
        host            => $self->request->server_name,
        cookie          => $self->request->cookie('my') // '',
        default         => 'ru',
    );

    $self->set_app_locale($user_lang);

    my $y_domain = get_yandex_domain($self->request->url);
    my ($y_tld) = $y_domain =~ /\.(com\.tr|com\.ua|[^\.]+)$/;
    $y_tld = 'ru' unless $y_tld;
    my $krim_nash = $y_tld eq 'ua' || $y_tld eq 'com.ua' ? 0 : 1;

    $self->set_option(secret_key    => get_not_auth_secretkey($self->request->cookie('yandexuid')));
    $self->set_option(yandex_domain => $y_domain);
    $self->set_option(yandex_tld    => $y_tld);
    $self->set_option(geo_rkim_nash => $krim_nash);
    $self->set_option(regions       => $regions);


    my $passport = $self->api_blackbox->_get_addr_pass($self->request->server_name, no_mda => $self->get_option('no_mda', 0))->{'host_passport'};
    $self->set_option(yandex_passport_host => $passport); 

    my $y_is_kubr = in_array($y_tld, [qw/ru ua by kz/]);

    if ($self->get_option('no_mda', 0)) {
        $self->set_option(yandex_tune_url => 'https://www.yandex.' . ($y_tld) . '/portal/set/lang/'); 
    } else {
        $self->set_option(yandex_tune_url => 'https://tune.yandex.' . ($y_is_kubr ? 'ru' : $y_tld) . '/api/lang/v1.1/save.xml'); 
    }



    # DIRECTSUP-30664 - редиректы на национальные домены не делаем
    # my $redir_domain = $self->get_domain_regional($regions, $y_domain);
    # if ($redir_domain) {
    #     my $url = $self->request->url;
    #     $url =~ s/$y_domain/$redir_domain/;
    #     return $controller->redirect2url($url);
    # }
}


sub get_domain_regional {
    my ($self, $regions, $domain) = @_;

    my ($tld) = $domain =~ /(com\.tr|com\.ua|[^\.]+)\/?$/;

    my $defs = {
        187 => 'ua',
        983 => 'com.tr',
    };

    while (my ($reg_id, $reg_tld) = each(%$defs)) {
        if (in_array($reg_id, $regions) && $tld ne $reg_tld) {
            $domain =~ s/$tld\/?$/$reg_tld/;
            return $domain;
        }
    }
    return;
}

sub post_cmd {
    my ($self) = @_;

    $self->response->headers->{'X-Frame-Options'} = 'Deny'
      if !exists($self->response->headers->{'X-Frame-Options'})
          && $self->response->content_type =~ /^text\/html/;
}

sub get_thousands_sep {
    my ($self) = @_;

    setlocale(Locale::Messages::LC_NUMERIC,
        $self->get_option('locales', {})->{$self->get_option('locale', 'ru_RU')}{'code'} . '.utf8');

    my $res = localeconv()->{'thousands_sep'};
    utf8::decode($res);

    return $res;
}

sub get_decimal_point {
    my ($self) = @_;

    setlocale(Locale::Messages::LC_NUMERIC,
        $self->get_option('locales', {})->{$self->get_option('locale', 'ru_RU')}{'code'} . '.utf8');

    my $res = localeconv()->{'decimal_point'};
    utf8::decode($res);

    return $res;
}

sub process_timelog {
    my ($self, $tl) = @_;

    if ($self->get_option('show_timelog')) {
        if ($self->response->content_type =~ /text\/html/ && defined($self->response->{'data'})) {
            my $tl_html = _tl2html($tl->_calc_percent([$tl->_analyze()]));
            (
                ref($self->response->{'data'}) eq 'SCALAR'
                ? ${$self->response->{'data'}}
                : $self->response->{'data'}
            ) =~ s/\<\/body\>/$tl_html<\/body>/;
        } else {
            $tl->print();
        }
    }
}

sub _tl2html {
    my ($log, $level) = @_;

    $level ||= 0;

    my $display = !$level ? 'block' : 'none';
    my $res = "<div style=\"padding-left: 20pt; display: $display;\">";

    foreach my $l (@$log) {
        my $text;
        $text = html_encode($l->[0]);
        for ($text) {
            s/ /&nbsp;/g;
            s/\r|\n|\r\n/<br>/g;
        }

        my $time = sprintf('%f',   $l->[1]{'t'});
        my $prc  = sprintf('%.2f', $l->[1]{'prc'});

        $res .= '<table style="background-color: #eeeeee; width: 100%;"'
          . ' onmouseover="this.parentNode.style.backgroundColor=\'#cccccc\'" onmouseout="this.parentNode.style.backgroundColor=\'\'"><tr';
        $res .=
            ' style="cursor: pointer;"'
          . ' onclick="var tbl = this.parentNode; while (tbl.nodeName != \'TABLE\') { tbl = tbl.parentNode};'
          . 'var chld_div = tbl.nextSibling;'
          . 'if (this.firstChild.innerHTML == \'+\') {chld_div.style.display = \'block\'; this.firstChild.innerHTML = \'-\';} else {chld_div.style.display = \'none\'; this.firstChild.innerHTML = \'+\';};'
          . 'return false;"'
          if exists($l->[2]);
        $res .=
            '><th width="15pt" valign="top">'
          . (exists($l->[2]) ? '+' : '&nbsp;') . '</th>'
          . "<th valign=\"top\" width=\"100pt\">$time sec:</th><td valign=\"top\""
          . (
            $level
            ? "style=\"background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAIAAAACDbGyAAAAAXNSR0IArs4c6QAAABRJREFUCNdjfH1oPQMSYGJABaTyAbokAmZIPrAXAAAAAElFTkSuQmCC); background-size: $prc% 100%; background-repeat: no-repeat;\""
            : ''
          ) . ">$text</td></tr></table>";
        $res .= _tl2html($l->[2], $level + 1) if exists($l->[2]);
    }
    $res .= '</div>';

    return $res;
}

sub _get_bb_cur_user {
    my ($self, $controller, %opts) = @_;

    my $bb_res;

    try {
        $bb_res = $self->api_blackbox->sessionid(
            session_id  => $self->request->cookie('Session_id'),
            sessionid2  => $self->request->cookie('sessionid2'),
            remote_addr => $self->request->remote_addr(),
            server_name => $self->request->server_name(),
            fields      => [qw(accounts.login.uid account_info.fio.uid subscription.suid.85)],
            no_mda      => $opts{'no_mda'},
        );
    }
    catch Exception::BlackBox::NeedAuth with {
        $bb_res = 0;
    }
    catch Exception::BlackBox::NeedResign with {
        my ($self) = @_;
        $bb_res = {
            redirect => $self->{url_resign}
              . "retpath="
              . uri_escape($controller->_get_url_absolute($controller->request->param('retpath', ''))),
            cookeis => $self->{cookies},
        };
    }
    catch Exception::BlackBox::NeedRealLogin with {
        my ($self) = @_;
        $bb_res =
          {     redirect => $self->{url_auth}
              . "mode=postregistration&create_login=1&from=&retpath="
              . uri_escape($controller->_get_url_absolute($controller->request->param('retpath', ''))),};
    };

    $bb_res = 0 if ($self->request->param('nocookiesupport'));

    # robots - welcome!
    if (in_array($self->request->http_header('User-Agent'), $self->get_option('robots_ua', []))) {
        $bb_res = 0;
    }

    my $cur_user;

    if ($bb_res == 0) {
        $cur_user = {};
    } elsif ($bb_res->{redirect}) {
        $bb_res->{redirect} =~ s/^\/\//https:\/\//;
        $controller->response->add_cookie(%{$bb_res->{cookeis}}) if ($bb_res->{cookeis});
        # exit
        $self->break($controller->redirect2url($bb_res->{redirect}));
    } else {
        {
            if (!$bb_res->{'auth'}{'secure'}{'content'}) {

                my $passport_host = $self->api_blackbox->_get_addr_pass($self->request->server_name, no_mda => $self->get_option('no_mda', 0))->{url_auth};

                # TODO: PASSP-3230

#                my $passport_logout_url =
#                    "https:$passport_host/passport?mode=logout&from=&yu="
#                  . uri_escape($controller->request->cookie('yandexuid'))
#                  . "&retpath="
#                  . uri_escape($controller->request->url());

                # exit
#                $self->break($controller->redirect2url($passport_logout_url));

            }


            $cur_user = {
                blackbox => TRUE,
                id       => $bb_res->{'uid'}{'content'},
                login    => $bb_res->{'dbfield'}{'accounts.login.uid'},
                email    => $bb_res->{'address-list'}->{'address'}->{content},
                password_verification_age => $bb_res->{'auth'}{'password_verification_age'}{'content'},
            };
            ($cur_user->{'lastname'}, $cur_user->{'name'}, $cur_user->{'midname'}) =
              (split(' ', $bb_res->{'dbfield'}{'account_info.fio.uid'} // ''), '', '', '');
        }
    }
    return $cur_user;
}

TRUE;
