package Wordstat::WebInterface::Controller::MagicalCookie;

use qbit;

use base qw(QBit::WebInterface::Controller);

use Digest::MD5 qw(md5_hex);

sub set : CMD : DEFAULT {
    my ($self) = @_;

    my $cur_user = $self->get_option('cur_user');
    my $url = $self->request->param(url => '');

    if (!$cur_user->{id}) {
        return $self->redirect2url('https://passport.yandex.ru/passport?mode=auth&msg=wordstat&retpath=' . uri_escape($self->request->url()));
    }

    return $self->response->status(400) unless $url;

    my $magical_cookie =
      md5_hex($self->get_option('SecretPhrase')
          . $self->request->remote_addr
          . $cur_user->{id});

    my $url_sign =
      md5_hex($self->get_option('SecretPhrase')
          . $self->request->remote_addr
          . $cur_user->{id}
          . $url);

    if ($self->request->param(sign => '') eq $url_sign) {
        $self->response->add_cookie(direct_advq => $magical_cookie, expires => '+3M');
        return $self->redirect2url($url);
    }

    ldump(
        {
            'Set magical cookie error' => {
                IP              => $self->request->remote_addr,
                X_FORWARDED_FOR => $self->request->http_header('X-Forwarded-For'),
                KEY             => $self->request->param('key'),
                URL             => $url,
                SIGN            => $self->request->param('sign'),
                UID             => $cur_user->{id},
            }
        }
    );

    $self->response->status(400);
}

TRUE;
